/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.helpers.MinecraftApi;
import net.minecraftcapes.player.PlayerHandler;

public class DownloadManager {
    public static void prepareDownload(UUID playerUUID, String playerName, boolean doRefresh) {
        class_746 localPlayer = class_310.method_1551().field_1724;
        if (playerUUID.version() != 4 && localPlayer != null && !localPlayer.method_5667().equals(playerUUID)) {
            return;
        }
        PlayerHandler playerHandler = PlayerHandler.get(playerUUID);
        if (playerUUID.version() != 4 && !playerHandler.getHasInfo().booleanValue() && !doRefresh) {
            playerHandler.setHasInfo(true);
            Thread playerDownload = new Thread(() -> {
                UUID uuid = MinecraftApi.getUUID(playerName);
                if (uuid == null) {
                    return;
                }
                playerHandler.setPlayerUUID(uuid);
                DownloadManager.downloadProfile(playerHandler);
            });
            playerDownload.setDaemon(true);
            playerDownload.start();
        } else if (!playerHandler.getHasInfo().booleanValue() || doRefresh) {
            DownloadManager.downloadProfile(playerHandler);
        }
    }

    private static void downloadProfile(PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(() -> {
            playerHandler.setHasInfo(true);
            byte[] playerDataBytes = DownloadManager.downloadData("https://api.minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
            if (playerDataBytes == null) {
                return;
            }
            try {
                byte[] earsBytes;
                byte[] capeBytes;
                String json = new String(playerDataBytes, StandardCharsets.UTF_8);
                ProfileResult profileResult = (ProfileResult)new Gson().fromJson(json, ProfileResult.class);
                playerHandler.setHasCapeGlint(profileResult.capeGlint);
                playerHandler.setUpsideDown(profileResult.upsideDown);
                if (profileResult.cape_url != null && (capeBytes = DownloadManager.downloadData(profileResult.cape_url)) != null) {
                    class_1011 capeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(capeBytes));
                    playerHandler.applyCape(capeImage);
                }
                if (profileResult.ear_url != null && (earsBytes = DownloadManager.downloadData(profileResult.ear_url)) != null) {
                    class_1011 earsImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(earsBytes));
                    playerHandler.applyEars(earsImage);
                }
            }
            catch (IOException e) {
                MinecraftCapes.getLogger().warn("Error downloading profile data", (Throwable)e);
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    private static byte[] downloadData(String url) {
        InputStream inputStream2;
        HttpURLConnection httpURLConnection = null;
        URI uri = URI.create(url);
        try {
            MinecraftCapes.getLogger().info("Getting texture {}", (Object)url);
            httpURLConnection = (HttpURLConnection)uri.toURL().openConnection(class_310.method_1551().method_1487());
            httpURLConnection.setRequestProperty("User-Agent", "minecraftcapes-mod/" + MinecraftCapes.MINECRAFT_VERSION);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() / 100 == 2) {
                inputStream2 = httpURLConnection.getInputStream();
                byte[] byArray = inputStream2.readAllBytes();
                return byArray;
            }
            MinecraftCapes.getLogger().warn("minecraftcapes.net returned a {}", (Object)httpURLConnection.getResponseCode());
            byte[] inputStream2 = null;
            return inputStream2;
        }
        catch (IOException e) {
            MinecraftCapes.getLogger().warn("No connection to minecraftcapes.net detected");
        }
        {
            finally {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        {
            throw new RuntimeException(e);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private String cape_url = null;
        private String ear_url = null;

        private ProfileResult() {
        }
    }
}

