/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.helpers.MinecraftApi;
import net.minecraftcapes.player.PlayerHandler;
import org.apache.commons.io.IOUtils;

public class DownloadManager {
    public static void prepareDownload(UUID uuid, String username, boolean doRefresh) {
        PlayerHandler playerHandler = PlayerHandler.get(uuid);
        if (!playerHandler.getHasInfo().booleanValue() || doRefresh) {
            playerHandler.setHasInfo(true);
            if (uuid.version() == 4) {
                DownloadManager.downloadProfile(playerHandler);
            } else if (uuid.version() == 3) {
                Thread prepareProfile = new Thread(() -> {
                    UUID onlineUUID = MinecraftApi.getUUID(username);
                    if (onlineUUID != null) {
                        playerHandler.setPlayerUUID(onlineUUID);
                        DownloadManager.downloadProfile(playerHandler);
                    }
                });
                prepareProfile.start();
            }
        }
    }

    private static void downloadProfile(PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(() -> {
            class_1011 earsImage;
            class_1011 capeImage;
            byte[] playerDataBytes = DownloadManager.downloadData("https://api.minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
            if (playerDataBytes == null) {
                return;
            }
            String json = new String(playerDataBytes, StandardCharsets.UTF_8);
            ProfileResult profileResult = (ProfileResult)new Gson().fromJson(json, ProfileResult.class);
            playerHandler.setHasCapeGlint(profileResult.capeGlint);
            playerHandler.setUpsideDown(profileResult.upsideDown);
            if (profileResult.cape_url != null && (capeImage = DownloadManager.downloadOrLoad(profileResult.cape_url, "capes")) != null) {
                playerHandler.applyCape(capeImage);
            }
            if (profileResult.ear_url != null && (earsImage = DownloadManager.downloadOrLoad(profileResult.ear_url, "ears")) != null) {
                playerHandler.applyEars(earsImage);
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    private static class_1011 downloadOrLoad(String url, String type) {
        class_1011 nativeImage;
        block13: {
            String hash = url.substring(url.lastIndexOf(47) + 1);
            Path cache = MinecraftCapes.getConfigDir().resolve(type).resolve(hash.length() > 2 ? hash.substring(0, 2) : "xx").resolve(hash);
            nativeImage = null;
            if (cache.toFile().exists()) {
                try (InputStream inputStream = Files.newInputStream(cache.toFile().toPath(), new OpenOption[0]);){
                    nativeImage = class_1011.method_4309((InputStream)inputStream);
                    break block13;
                }
                catch (IOException e) {
                    MinecraftCapes.getLogger().error("IOException with {}", (Object)cache);
                    MinecraftCapes.getLogger().error(e.getMessage());
                    if (cache.toFile().delete()) {
                        return DownloadManager.downloadOrLoad(url, type);
                    }
                    return null;
                }
            }
            byte[] imageBytes = DownloadManager.downloadData(url);
            if (imageBytes != null) {
                try {
                    Files.createDirectories(cache.getParent(), new FileAttribute[0]);
                    Files.write(cache, imageBytes, new OpenOption[0]);
                    nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(imageBytes));
                }
                catch (IOException e) {
                    MinecraftCapes.getLogger().error("IOException with {}", (Object)url);
                    MinecraftCapes.getLogger().error(e.getMessage());
                    return null;
                }
            }
        }
        return nativeImage;
    }

    private static byte[] downloadData(String url) {
        InputStream inputStream2;
        HttpURLConnection httpURLConnection = null;
        URI uri = URI.create(url);
        try {
            MinecraftCapes.getLogger().info("Getting texture {}", (Object)url);
            httpURLConnection = (HttpURLConnection)uri.toURL().openConnection(class_310.method_1551().method_1487());
            httpURLConnection.setRequestProperty("User-Agent", "minecraftcapes-mod/" + MinecraftCapes.MINECRAFT_VERSION);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() / 100 == 2) {
                inputStream2 = httpURLConnection.getInputStream();
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream2);
                return byArray;
            }
            MinecraftCapes.getLogger().warn("minecraftcapes.net returned a {}", (Object)httpURLConnection.getResponseCode());
            byte[] inputStream2 = null;
            return inputStream2;
        }
        catch (IOException e) {
            MinecraftCapes.getLogger().warn("No connection to minecraftcapes.net detected");
        }
        {
            finally {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        {
            throw new RuntimeException(e);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private String cape_url = null;
        private String ear_url = null;

        private ProfileResult() {
        }
    }
}

