/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.spongepowered.asm.mixin.injection.code;

import java.util.HashMap;
import java.util.Map;
import net.minecraftcapes.spongepowered.asm.lib.tree.AnnotationNode;
import net.minecraftcapes.spongepowered.asm.lib.tree.InsnList;
import net.minecraftcapes.spongepowered.asm.lib.tree.MethodNode;
import net.minecraftcapes.spongepowered.asm.mixin.injection.InjectionPoint;
import net.minecraftcapes.spongepowered.asm.mixin.injection.code.ISliceContext;
import net.minecraftcapes.spongepowered.asm.mixin.injection.code.MethodSlice;
import net.minecraftcapes.spongepowered.asm.mixin.injection.code.ReadOnlyInsnList;
import net.minecraftcapes.spongepowered.asm.mixin.injection.struct.Target;
import net.minecraftcapes.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import net.minecraftcapes.spongepowered.asm.util.Annotations;

public class InjectorTarget {
    private final ISliceContext context;
    private final Map<String, ReadOnlyInsnList> cache = new HashMap<String, ReadOnlyInsnList>();
    private final Target target;
    private final String mergedBy;
    private final int mergedPriority;

    public InjectorTarget(ISliceContext context, Target target) {
        this.context = context;
        this.target = target;
        AnnotationNode merged = Annotations.getVisible(target.method, MixinMerged.class);
        this.mergedBy = (String)Annotations.getValue(merged, "mixin");
        this.mergedPriority = Annotations.getValue(merged, "priority", 1000);
    }

    public String toString() {
        return this.target.toString();
    }

    public Target getTarget() {
        return this.target;
    }

    public MethodNode getMethod() {
        return this.target.method;
    }

    public boolean isMerged() {
        return this.mergedBy != null;
    }

    public String getMergedBy() {
        return this.mergedBy;
    }

    public int getMergedPriority() {
        return this.mergedPriority;
    }

    public InsnList getSlice(String id) {
        ReadOnlyInsnList slice = this.cache.get(id);
        if (slice == null) {
            MethodSlice sliceInfo = this.context.getSlice(id);
            slice = sliceInfo != null ? sliceInfo.getSlice(this.target.method) : new ReadOnlyInsnList(this.target.method.instructions);
            this.cache.put(id, slice);
        }
        return slice;
    }

    public InsnList getSlice(InjectionPoint injectionPoint) {
        return this.getSlice(injectionPoint.getSlice());
    }

    public void dispose() {
        for (ReadOnlyInsnList insns : this.cache.values()) {
            insns.dispose();
        }
        this.cache.clear();
    }
}

