/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.config.MinecraftCapesConfig;

public class PlayerHandler {
    private static final HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private Int2ObjectMap<NativeImage> animatedCape;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(UUID uuid) {
        this.playerUUID = uuid;
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler get(UUID uuid) {
        PlayerHandler playerHandler = instances.get(uuid);
        return playerHandler == null ? new PlayerHandler(uuid) : playerHandler;
    }

    public static void remove(UUID uuid) {
        instances.remove(uuid);
    }

    public void applyCape(NativeImage capeImage) {
        if (capeImage.getHeight() != capeImage.getWidth() / 2) {
            Int2ObjectOpenHashMap animatedCapeFrames = new Int2ObjectOpenHashMap();
            int totalFrames = capeImage.getHeight() / (capeImage.getWidth() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                NativeImage frame = new NativeImage(capeImage.getWidth(), capeImage.getWidth() / 2, true);
                for (int x = 0; x < frame.getWidth(); ++x) {
                    for (int y = 0; y < frame.getHeight(); ++y) {
                        frame.setPixelRGBA(x, y, capeImage.getPixelRGBA(x, y + currentFrame * (capeImage.getWidth() / 2)));
                    }
                }
                animatedCapeFrames.put(currentFrame, (Object)frame);
            }
            this.setAnimatedCape((Int2ObjectMap<NativeImage>)animatedCapeFrames);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", (Object)this.playerUUID);
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.getWidth();
            int srcHeight = capeImage.getHeight();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            NativeImage imgNew = new NativeImage(imageWidth, imageHeight, true);
            for (int x = 0; x < capeImage.getWidth(); ++x) {
                for (int y = 0; y < capeImage.getHeight(); ++y) {
                    imgNew.setPixelRGBA(x, y, capeImage.getPixelRGBA(x, y));
                }
            }
            capeImage.close();
            this.applyTexture(new ResourceLocation("minecraftcapes", "capes/" + String.valueOf(this.playerUUID)), imgNew);
            this.setHasStaticCape(true);
            this.setHasAnimatedCape(false);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", (Object)this.playerUUID);
        }
    }

    public void applyEars(NativeImage earImage) {
        this.applyTexture(new ResourceLocation("minecraftcapes", "ears/" + String.valueOf(this.playerUUID)), earImage);
        this.setHasEars(true);
    }

    public void removeCape() {
        if (!this.hasStaticCape && !this.hasAnimatedCape) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing cape for {}", (Object)this.playerUUID);
        this.setHasAnimatedCape(false);
        this.setHasStaticCape(false);
        Minecraft.getInstance().execute(() -> {
            Minecraft.getInstance().getTextureManager().release(new ResourceLocation("minecraftcapes", "capes/" + String.valueOf(this.playerUUID)));
            for (int i = 0; i < this.getAnimatedCape().size() - 1; ++i) {
                Minecraft.getInstance().getTextureManager().release(new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, i)));
            }
        });
    }

    public void removeEars() {
        if (!this.hasEars) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing ears for {}", (Object)this.playerUUID);
        this.setHasEars(false);
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().getTextureManager().release(new ResourceLocation("minecraftcapes", "ears/" + String.valueOf(this.playerUUID))));
    }

    public void setAnimatedCape(Int2ObjectMap<NativeImage> animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", (Object)this.playerUUID);
        this.animatedCape = animatedCape;
        this.setHasStaticCape(false);
        this.setHasAnimatedCape(true);
        this.loadFramesToResource();
    }

    private void loadFramesToResource() {
        MinecraftCapes.getLogger().debug("Loading resources to memory for {}", (Object)this.playerUUID);
        this.getAnimatedCape().forEach((integer, nativeImage) -> {
            ResourceLocation currentResource = new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, integer));
            this.applyTexture(currentResource, (NativeImage)nativeImage);
        });
    }

    private ResourceLocation getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.getAnimatedCape().size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, currentFrameNo));
        }
        return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, this.lastFrame));
    }

    public ResourceLocation getCapeLocation() {
        return this.hasStaticCape ? new ResourceLocation("minecraftcapes", "capes/" + String.valueOf(this.playerUUID)) : (this.hasAnimatedCape ? this.getFrame() : null);
    }

    public ResourceLocation getEarLocation() {
        return this.hasEars ? new ResourceLocation("minecraftcapes", "ears/" + String.valueOf(this.playerUUID)) : null;
    }

    private void applyTexture(ResourceLocation resourcelocation, NativeImage nativeImage) {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().getTextureManager().register(resourcelocation, (AbstractTexture)new DynamicTexture(nativeImage)));
    }

    public PlayerSkin getSkin(PlayerSkin original) {
        ResourceLocation capeTexture = original.capeTexture();
        ResourceLocation elytraTexture = original.elytraTexture();
        if (MinecraftCapesConfig.isCapeVisible() && this.getCapeLocation() != null) {
            elytraTexture = capeTexture = this.getCapeLocation();
        }
        return new PlayerSkin(original.texture(), original.textureUrl(), capeTexture, elytraTexture, original.model(), original.secure());
    }

    @Generated
    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    @Generated
    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    @Generated
    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    @Generated
    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    @Generated
    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Generated
    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public Int2ObjectMap<NativeImage> getAnimatedCape() {
        return this.animatedCape;
    }
}

