/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.client.Minecraft;
import net.minecraftcapes.MinecraftCapes;

public class PlayerHandler {
    private static final HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private Int2IntArrayMap animatedCape;
    private int cape;
    private int ears;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(UUID uuid) {
        this.playerUUID = uuid;
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler get(UUID uuid) {
        PlayerHandler playerHandler = instances.get(uuid);
        return playerHandler == null ? new PlayerHandler(uuid) : playerHandler;
    }

    public static void remove(UUID uuid) {
        instances.remove(uuid);
    }

    public void applyCape(BufferedImage capeImage) {
        if (capeImage.getHeight() != capeImage.getWidth() / 2) {
            Int2IntArrayMap animatedCape = new Int2IntArrayMap();
            int totalFrames = capeImage.getHeight() / (capeImage.getWidth() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                BufferedImage frame = new BufferedImage(capeImage.getWidth(), capeImage.getWidth() / 2, 2);
                Graphics frameGraphics = frame.getGraphics();
                frameGraphics.drawImage(capeImage, 0, 0, capeImage.getWidth(), capeImage.getWidth() / 2, 0, currentFrame * (capeImage.getWidth() / 2), capeImage.getWidth(), (currentFrame + 1) * (capeImage.getWidth() / 2), null);
                frameGraphics.dispose();
                animatedCape.put(currentFrame, this.applyTexture(frame));
            }
            this.setAnimatedCape(animatedCape);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", (Object)this.playerUUID);
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.getWidth();
            int srcHeight = capeImage.getHeight();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            BufferedImage imgNew = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics g = imgNew.getGraphics();
            g.drawImage(capeImage, 0, 0, null);
            g.dispose();
            this.cape = this.applyTexture(imgNew);
            this.setHasStaticCape(true);
            this.setHasAnimatedCape(false);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", (Object)this.playerUUID);
        }
    }

    public void applyEars(BufferedImage earImage) {
        BufferedImage imgNew = new BufferedImage(64, 32, 2);
        Graphics g = imgNew.getGraphics();
        g.drawImage(earImage, 24, 0, null);
        g.dispose();
        this.ears = this.applyTexture(imgNew);
        this.setHasEars(true);
    }

    public void setAnimatedCape(Int2IntArrayMap animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", (Object)this.playerUUID);
        this.animatedCape = animatedCape;
        this.setHasStaticCape(false);
        this.setHasAnimatedCape(true);
    }

    private int getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.animatedCape.size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return this.animatedCape.get(currentFrameNo);
        }
        return this.animatedCape.get(this.lastFrame);
    }

    public int getCapeLocation() {
        return this.hasStaticCape ? this.cape : (this.hasAnimatedCape ? this.getFrame() : -1);
    }

    public int getEarLocation() {
        return this.hasEars ? this.ears : -1;
    }

    private int applyTexture(BufferedImage bufferedImage) {
        Minecraft gameInstance = (Minecraft)FabricLoaderImpl.INSTANCE.getGameInstance();
        return gameInstance.field_2814.method_1088(bufferedImage);
    }

    @Generated
    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    @Generated
    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    @Generated
    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    @Generated
    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    @Generated
    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Generated
    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

