/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.mixin;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.DownloadManager;
import net.minecraftcapes.player.PlayerHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class MixinPlayerInfo {
    @Shadow
    @Final
    private GameProfile profile;

    @Inject(method={"createSkinLookup"}, at={@At(value="HEAD")})
    private static void createSkinLookup(GameProfile profile, CallbackInfoReturnable<Supplier<PlayerSkin>> cir) {
        DownloadManager.prepareDownload(profile.getId(), profile.getName(), false);
    }

    @Inject(method={"getSkin"}, at={@At(value="TAIL")}, cancellable=true)
    public void getSkin(CallbackInfoReturnable<PlayerSkin> cir) {
        PlayerHandler playerHandler = PlayerHandler.get(this.profile.getId());
        if (playerHandler.getHasInfo().booleanValue()) {
            PlayerSkin playerSkin = (PlayerSkin)cir.getReturnValue();
            ResourceLocation capeTexture = playerSkin.capeTexture();
            ResourceLocation elytraTexture = playerSkin.elytraTexture();
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                capeTexture = playerHandler.getCapeLocation();
                elytraTexture = playerHandler.getCapeLocation();
            }
            PlayerSkin newPlayerSkin = new PlayerSkin(playerSkin.texture(), playerSkin.textureUrl(), capeTexture, elytraTexture, playerSkin.model(), playerSkin.secure());
            cir.setReturnValue((Object)newPlayerSkin);
        }
    }
}

