/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.config.MinecraftCapesConfig;

public class PlayerHandler {
    private static final HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private Int2ObjectMap<class_1011> animatedCape;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(UUID uuid) {
        this.playerUUID = uuid;
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler get(UUID uuid) {
        PlayerHandler playerHandler = instances.get(uuid);
        return playerHandler == null ? new PlayerHandler(uuid) : playerHandler;
    }

    public static void remove(UUID uuid) {
        instances.remove(uuid);
    }

    public void applyCape(class_1011 capeImage) {
        if (capeImage.method_4323() != capeImage.method_4307() / 2) {
            Int2ObjectOpenHashMap animatedCapeFrames = new Int2ObjectOpenHashMap();
            int totalFrames = capeImage.method_4323() / (capeImage.method_4307() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                class_1011 frame = new class_1011(capeImage.method_4307(), capeImage.method_4307() / 2, true);
                for (int x = 0; x < frame.method_4307(); ++x) {
                    for (int y = 0; y < frame.method_4323(); ++y) {
                        frame.method_61941(x, y, capeImage.method_61940(x, y + currentFrame * (capeImage.method_4307() / 2)));
                    }
                }
                animatedCapeFrames.put(currentFrame, (Object)frame);
            }
            this.setAnimatedCape((Int2ObjectMap<class_1011>)animatedCapeFrames);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", (Object)this.playerUUID);
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.method_4307();
            int srcHeight = capeImage.method_4323();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            class_1011 imgNew = new class_1011(imageWidth, imageHeight, true);
            for (int x = 0; x < capeImage.method_4307(); ++x) {
                for (int y = 0; y < capeImage.method_4323(); ++y) {
                    imgNew.method_61941(x, y, capeImage.method_61940(x, y));
                }
            }
            capeImage.close();
            this.applyTexture(class_2960.method_60655((String)"minecraftcapes", (String)("capes/" + String.valueOf(this.playerUUID))), imgNew);
            this.setHasStaticCape(true);
            this.setHasAnimatedCape(false);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", (Object)this.playerUUID);
        }
    }

    public void applyEars(class_1011 earImage) {
        this.applyTexture(class_2960.method_60655((String)"minecraftcapes", (String)("ears/" + String.valueOf(this.playerUUID))), earImage);
        this.setHasEars(true);
    }

    public void removeCape() {
        if (!this.hasStaticCape && !this.hasAnimatedCape) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing cape for {}", (Object)this.playerUUID);
        this.setHasAnimatedCape(false);
        this.setHasStaticCape(false);
        class_310.method_1551().execute(() -> {
            class_310.method_1551().method_1531().method_4615(class_2960.method_60655((String)"minecraftcapes", (String)("capes/" + String.valueOf(this.playerUUID))));
            for (int i = 0; i < this.getAnimatedCape().size() - 1; ++i) {
                class_310.method_1551().method_1531().method_4615(class_2960.method_60655((String)"minecraftcapes", (String)String.format("capes/%s/%d", this.playerUUID, i)));
            }
        });
    }

    public void removeEars() {
        if (!this.hasEars) {
            return;
        }
        MinecraftCapes.getLogger().debug("Removing ears for {}", (Object)this.playerUUID);
        this.setHasEars(false);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4615(class_2960.method_60655((String)"minecraftcapes", (String)("ears/" + String.valueOf(this.playerUUID)))));
    }

    public void setAnimatedCape(Int2ObjectMap<class_1011> animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", (Object)this.playerUUID);
        this.animatedCape = animatedCape;
        this.setHasStaticCape(false);
        this.setHasAnimatedCape(true);
        this.loadFramesToResource();
    }

    private void loadFramesToResource() {
        MinecraftCapes.getLogger().debug("Loading resources to memory for {}", (Object)this.playerUUID);
        this.getAnimatedCape().forEach((integer, nativeImage) -> {
            class_2960 currentResource = class_2960.method_60655((String)"minecraftcapes", (String)String.format("capes/%s/%d", this.playerUUID, integer));
            this.applyTexture(currentResource, (class_1011)nativeImage);
        });
    }

    private class_2960 getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.getAnimatedCape().size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return class_2960.method_60655((String)"minecraftcapes", (String)String.format("capes/%s/%d", this.playerUUID, currentFrameNo));
        }
        return class_2960.method_60655((String)"minecraftcapes", (String)String.format("capes/%s/%d", this.playerUUID, this.lastFrame));
    }

    public class_2960 getCapeLocation() {
        return this.hasStaticCape ? class_2960.method_60655((String)"minecraftcapes", (String)("capes/" + String.valueOf(this.playerUUID))) : (this.hasAnimatedCape ? this.getFrame() : null);
    }

    public class_2960 getEarLocation() {
        return this.hasEars ? class_2960.method_60655((String)"minecraftcapes", (String)("ears/" + String.valueOf(this.playerUUID))) : null;
    }

    private void applyTexture(class_2960 resourcelocation, class_1011 nativeImage) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(resourcelocation, (class_1044)new class_1043(() -> ((class_2960)resourcelocation).toString(), nativeImage)));
    }

    public class_8685 getSkin(class_8685 original) {
        class_12079.class_12081 capeTexture = original.comp_1627();
        class_12079.class_12081 elytraTexture = original.comp_1628();
        if (MinecraftCapesConfig.isCapeVisible() && this.getCapeLocation() != null) {
            elytraTexture = capeTexture = new class_12079.class_10726(this.getCapeLocation(), this.getCapeLocation());
        }
        return new class_8685(original.comp_1626(), capeTexture, elytraTexture, original.comp_1629(), original.comp_1630());
    }

    @Generated
    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    @Generated
    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    @Generated
    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    @Generated
    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    @Generated
    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Generated
    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public Int2ObjectMap<class_1011> getAnimatedCape() {
        return this.animatedCape;
    }
}

