/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftcapes.MinecraftCapes;

public class MinecraftApi {
    public static UUID getUUID(String username) {
        JsonElement playerUUID;
        MinecraftCapes.getLogger().debug("Making an API call for {}", new Object[]{username});
        JsonObject playerElement = MinecraftApi.getApiData(username);
        if (playerElement != null && (playerUUID = playerElement.get("full_uuid")) != null && !playerUUID.isJsonNull()) {
            MinecraftCapes.getLogger().debug("{} ({}) was found", new Object[]{username, playerUUID});
            return UUID.fromString(playerUUID.getAsString());
        }
        MinecraftCapes.getLogger().debug("{} was not found", new Object[]{username});
        return null;
    }

    private static JsonObject getApiData(String data) {
        try {
            URI uri = URI.create("https://api.minecraftapi.net/api/v2/profile/" + data);
            HttpURLConnection httpurlconnection = (HttpURLConnection)uri.toURL().openConnection(Minecraft.func_71410_x().func_110437_J());
            httpurlconnection.setRequestProperty("User-Agent", "minecraftcapes-mod/1.7.10");
            httpurlconnection.setDoInput(true);
            httpurlconnection.setDoOutput(false);
            httpurlconnection.connect();
            if (httpurlconnection.getResponseCode() / 100 == 2) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(httpurlconnection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                return new JsonParser().parse(response.toString()).getAsJsonObject();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

