/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftcapes.MinecraftCapes;

public class PlayerHandler {
    private static HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean showCape = true;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private HashMap<Integer, BufferedImage> animatedCape;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(UUID uuid) {
        this.playerUUID = uuid;
        instances.put(this.playerUUID, this);
    }

    @Deprecated
    public PlayerHandler(EntityPlayer player) {
        this.playerUUID = player.func_110124_au();
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler get(UUID uuid) {
        PlayerHandler playerHandler = instances.get(uuid);
        return playerHandler == null ? new PlayerHandler(uuid) : playerHandler;
    }

    @Deprecated
    public static PlayerHandler getFromPlayer(EntityPlayer player) {
        return PlayerHandler.get(player.func_110124_au());
    }

    public void applyCape(BufferedImage capeImage) {
        if (capeImage.getHeight() != capeImage.getWidth() / 2) {
            HashMap<Integer, BufferedImage> animatedCape = new HashMap<Integer, BufferedImage>();
            int totalFrames = capeImage.getHeight() / (capeImage.getWidth() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                BufferedImage frame = new BufferedImage(capeImage.getWidth(), capeImage.getWidth() / 2, 2);
                Graphics frameGraphics = frame.getGraphics();
                frameGraphics.drawImage(capeImage, 0, 0, capeImage.getWidth(), capeImage.getWidth() / 2, 0, currentFrame * (capeImage.getWidth() / 2), capeImage.getWidth(), (currentFrame + 1) * (capeImage.getWidth() / 2), null);
                frameGraphics.dispose();
                animatedCape.put(currentFrame, frame);
            }
            this.setAnimatedCape(animatedCape);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", new Object[]{this.playerUUID});
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.getWidth();
            int srcHeight = capeImage.getHeight();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            BufferedImage imgNew = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics g = imgNew.getGraphics();
            g.drawImage(capeImage, 0, 0, null);
            g.dispose();
            this.applyTexture(new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID), imgNew);
            this.setHasStaticCape(true);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", new Object[]{this.playerUUID});
        }
    }

    public void applyEars(BufferedImage earImage) {
        this.applyTexture(new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID), earImage);
        this.setHasEars(true);
    }

    public void setAnimatedCape(HashMap<Integer, BufferedImage> animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", new Object[]{this.playerUUID});
        this.animatedCape = animatedCape;
        this.setHasAnimatedCape(true);
        this.loadFramesToResource();
    }

    private void loadFramesToResource() {
        MinecraftCapes.getLogger().debug("Loading resources to memory for {}", new Object[]{this.playerUUID});
        for (Map.Entry<Integer, BufferedImage> entry : this.getAnimatedCape().entrySet()) {
            ResourceLocation currentResource = new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, entry.getKey()));
            this.applyTexture(currentResource, entry.getValue());
        }
    }

    private ResourceLocation getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.getAnimatedCape().size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, currentFrameNo));
        }
        return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, this.lastFrame));
    }

    public ResourceLocation getCapeLocation() {
        return this.hasStaticCape ? new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID) : (this.hasAnimatedCape ? this.getFrame() : null);
    }

    public ResourceLocation getEarLocation() {
        return this.hasEars ? new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID) : null;
    }

    private void applyTexture(ResourceLocation resourceLocation, BufferedImage bufferedImage) {
        Minecraft.func_71410_x().func_152343_a(() -> Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new DynamicTexture(bufferedImage)));
    }

    public String toString() {
        return "PlayerHandler{hasStaticCape=" + this.hasStaticCape + ", hasEars=" + this.hasEars + ", hasAnimatedCape=" + this.hasAnimatedCape + ", hasCapeGlint=" + this.hasCapeGlint + ", upsideDown=" + this.upsideDown + ", hasInfo=" + this.hasInfo + ", playerUUID=" + this.playerUUID + ", animatedCape=" + this.animatedCape + ", lastFrameTime=" + this.lastFrameTime + ", lastFrame=" + this.lastFrame + ", capeInterval=" + this.capeInterval + '}';
    }

    @Generated
    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    @Generated
    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    @Generated
    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    @Generated
    public Boolean getShowCape() {
        return this.showCape;
    }

    @Generated
    public void setShowCape(Boolean showCape) {
        this.showCape = showCape;
    }

    @Generated
    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    @Generated
    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    @Generated
    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public HashMap<Integer, BufferedImage> getAnimatedCape() {
        return this.animatedCape;
    }
}

