/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.spongepowered.tools.obfuscation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import net.minecraftcapes.spongepowered.asm.mixin.injection.Inject;
import net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyArg;
import net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyArgs;
import net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyConstant;
import net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyVariable;
import net.minecraftcapes.spongepowered.asm.mixin.injection.Redirect;
import net.minecraftcapes.spongepowered.tools.obfuscation.MixinObfuscationProcessor;
import net.minecraftcapes.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import net.minecraftcapes.spongepowered.tools.obfuscation.mirror.TypeUtils;

@SupportedAnnotationTypes(value={"net.minecraftcapes.spongepowered.asm.mixin.injection.Inject", "net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyArg", "net.minecraftcapes.spongepowered.asm.mixin.injection.ModifyArgs", "net.minecraftcapes.spongepowered.asm.mixin.injection.Redirect", "net.minecraftcapes.spongepowered.asm.mixin.injection.At"})
public class MixinObfuscationProcessorInjection
extends MixinObfuscationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.postProcess(roundEnv);
            return true;
        }
        this.processMixins(roundEnv);
        this.processInjectors(roundEnv, Inject.class);
        this.processInjectors(roundEnv, ModifyArg.class);
        this.processInjectors(roundEnv, ModifyArgs.class);
        this.processInjectors(roundEnv, Redirect.class);
        this.processInjectors(roundEnv, ModifyVariable.class);
        this.processInjectors(roundEnv, ModifyConstant.class);
        this.postProcess(roundEnv);
        return true;
    }

    @Override
    protected void postProcess(RoundEnvironment roundEnv) {
        super.postProcess(roundEnv);
        try {
            this.mixins.writeReferences();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processInjectors(RoundEnvironment roundEnv, Class<? extends Annotation> injectorClass) {
        for (Element element : roundEnv.getElementsAnnotatedWith(injectorClass)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                throw new IllegalStateException("@" + injectorClass.getSimpleName() + " element has unexpected parent with type " + TypeUtils.getElementType(parent));
            }
            AnnotationHandle inject = AnnotationHandle.of(element, injectorClass);
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerInjector((TypeElement)parent, (ExecutableElement)element, inject);
                continue;
            }
            this.mixins.printMessage(Diagnostic.Kind.WARNING, "Found an @" + injectorClass.getSimpleName() + " annotation on an element which is not a method: " + element.toString());
        }
    }
}

