/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.config;

import com.google.gson.Gson;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftcapes.MinecraftCapes;

public class MinecraftCapesConfig {
    private static final Path configFile = MinecraftCapes.getConfigDir().resolve("minecraftcapes.json");
    private static ConfigValues config = new ConfigValues();

    public static void setCapeVisible(boolean enabled) {
        config.capeVisible = enabled;
        MinecraftCapesConfig.saveConfig();
    }

    public static void setEarsVisible(boolean enabled) {
        config.earsVisible = enabled;
        MinecraftCapesConfig.saveConfig();
    }

    public static boolean isCapeVisible() {
        return config.capeVisible;
    }

    public static boolean isEarsVisible() {
        return config.earsVisible;
    }

    public static void loadConfig() {
        block3: {
            try {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                if (!configFile.toFile().exists()) {
                    MinecraftCapesConfig.saveConfig();
                }
                FileReader reader = new FileReader(configFile.toFile());
                config = (ConfigValues)new Gson().fromJson((Reader)reader, ConfigValues.class);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                if (!configFile.toFile().delete()) break block3;
                MinecraftCapesConfig.loadConfig();
            }
        }
    }

    private static void saveConfig() {
        try {
            FileWriter writer = new FileWriter(configFile.toFile());
            new Gson().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ConfigValues getConfig() {
        return config;
    }

    static class ConfigValues {
        private boolean capeVisible = true;
        private boolean earsVisible = true;

        ConfigValues() {
        }
    }
}

