/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.cobbledlevels;

import cobbledlevels.CobbledLevelsConfig;
import cobbledlevels.ConfigLoader;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0019\u0010\b\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001fR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001fR\u0014\u0010#\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0016\u0010&\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lcom/github/slaxlax/cobbledlevels/LevelListener;", "", "<init>", "()V", "", "register", "Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;", "event", "onPokemonSpawn", "(Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;)V", "", "level", "min", "max", "applySimpleClamp", "(ILjava/lang/Integer;Ljava/lang/Integer;)I", "minLevel", "maxLevel", "scaleLevelToRange", "(III)I", "", "", "entries", "", "getLevelMap", "(Ljava/util/List;)Ljava/util/Map;", "Lcobbledlevels/CobbledLevelsConfig;", "kotlin.jvm.PlatformType", "config", "Lcobbledlevels/CobbledLevelsConfig;", "dimensionMinLevels", "Ljava/util/Map;", "dimensionMaxLevels", "biomeMinLevels", "biomeMaxLevels", "minScalingLevel", "I", "maxScalingLevel", "scaledAmount", "CobbledLevels-fabric"})
@SourceDebugExtension(value={"SMAP\nLevelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelListener.kt\ncom/github/slaxlax/cobbledlevels/LevelListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n827#2:167\n855#2,2:168\n1563#2:170\n1634#2,3:171\n1617#2,9:174\n1869#2:183\n1563#2:184\n1634#2,3:185\n1870#2:189\n1626#2:190\n1#3:188\n*S KotlinDebug\n*F\n+ 1 LevelListener.kt\ncom/github/slaxlax/cobbledlevels/LevelListener\n*L\n59#1:167\n59#1:168,2\n59#1:170\n59#1:171,3\n155#1:174,9\n155#1:183\n156#1:184\n156#1:185,3\n155#1:189\n155#1:190\n155#1:188\n*E\n"})
public final class LevelListener {
    @NotNull
    public static final LevelListener INSTANCE = new LevelListener();
    private static final CobbledLevelsConfig config = ConfigLoader.loadConfig();
    @NotNull
    private static final Map<String, Integer> dimensionMinLevels;
    @NotNull
    private static final Map<String, Integer> dimensionMaxLevels;
    @NotNull
    private static final Map<String, Integer> biomeMinLevels;
    @NotNull
    private static final Map<String, Integer> biomeMaxLevels;
    private static final int minScalingLevel;
    private static final int maxScalingLevel;
    private static int scaledAmount;

    private LevelListener() {
    }

    public final void register() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.HIGH, new Function1<SpawnEvent<?>, Unit>(this){

            public final void invoke(SpawnEvent<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((LevelListener)this.receiver).onPokemonSpawn(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void onPokemonSpawn(@NotNull SpawnEvent<?> event) {
        Integer n;
        Integer minLevel;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        class_1297 entity = event.getEntity();
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        int originalLevel = pokemon.getLevel();
        class_2338 blockPos = entity.method_24515();
        String biome = ((PokemonEntity)entity).method_37908().method_23753(blockPos).method_40230().map(arg_0 -> LevelListener.onPokemonSpawn$lambda$1(LevelListener::onPokemonSpawn$lambda$0, arg_0)).orElse(null);
        String string = ((PokemonEntity)entity).method_37908().method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String dimension = string;
        if (LevelListener.config.ExcludedPokemon.contains(pokemon.getSpecies().getResourceIdentifier().toString())) {
            return;
        }
        Integer biomeMin = biomeMinLevels.get(biome);
        Integer biomeMax = biomeMaxLevels.get(biome);
        Integer dimensionMin = dimensionMinLevels.get(dimension);
        Integer dimensionMax = dimensionMaxLevels.get(dimension);
        Integer n2 = biomeMin;
        if (n2 == null) {
            n2 = minLevel = dimensionMin;
        }
        if ((n = biomeMax) == null) {
            n = dimensionMax;
        }
        Integer maxLevel = n;
        int finalLevel = originalLevel;
        if (LevelListener.config.EnablePartyScaling && finalLevel >= minScalingLevel && finalLevel < maxScalingLevel) {
            class_3222 player;
            class_1657 class_16572 = ((PokemonEntity)entity).method_37908().method_18460(entity, (double)Cobblemon.INSTANCE.getConfig().getMaximumSpawningZoneDistanceFromPlayer());
            class_3222 class_32222 = player = class_16572 instanceof class_3222 ? (class_3222)class_16572 : null;
            if (player != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Pokemon it;
                void $this$filterNotTo$iv$iv;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                Iterable $this$filterNot$iv = (Iterable)party;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (Pokemon)element$iv$iv;
                    boolean bl = false;
                    if (it.isFainted()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pokemon)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLevel());
                }
                List partyLevels = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (!((Collection)partyLevels).isEmpty()) {
                    int median = partyLevels.size() % 2 == 0 ? (((Number)partyLevels.get(partyLevels.size() / 2 - 1)).intValue() + ((Number)partyLevels.get(partyLevels.size() / 2)).intValue()) / 2 : ((Number)partyLevels.get(partyLevels.size() / 2)).intValue();
                    Comparable comparable = CollectionsKt.maxOrNull((Iterable)partyLevels);
                    Intrinsics.checkNotNull((Object)comparable);
                    int n3 = ((Number)((Object)comparable)).intValue();
                    Comparable comparable2 = CollectionsKt.minOrNull((Iterable)partyLevels);
                    Intrinsics.checkNotNull((Object)comparable2);
                    int spread = n3 - ((Number)((Object)comparable2)).intValue();
                    int variance = Math.max(LevelListener.config.MinPartyScalingVariance, spread / 2);
                    Integer n4 = minLevel;
                    int lowerBound = RangesKt.coerceAtLeast((int)(median - variance), (int)(n4 != null ? n4 : 1));
                    Integer n5 = maxLevel;
                    int upperBound = RangesKt.coerceAtMost((int)(median + variance), (int)(n5 != null ? n5.intValue() : Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel()));
                    if (originalLevel < lowerBound) {
                        int scaled = this.scaleLevelToRange(finalLevel, lowerBound, upperBound);
                        v9 = Math.max(scaled, originalLevel);
                    } else {
                        v9 = finalLevel = originalLevel;
                    }
                }
            }
        }
        if (LevelListener.config.EnableDistanceScaling && finalLevel >= minScalingLevel && finalLevel < maxScalingLevel) {
            class_2338 worldSpawn;
            MinecraftServer minecraftServer = ((PokemonEntity)entity).method_5682();
            class_2338 class_23382 = minecraftServer != null && (minecraftServer = minecraftServer.method_3847(((PokemonEntity)entity).method_37908().method_27983())) != null ? minecraftServer.method_43126() : (worldSpawn = null);
            if (worldSpawn != null) {
                double dx = blockPos.method_10263() - worldSpawn.method_10263();
                double dy = blockPos.method_10264() - worldSpawn.method_10264();
                double dz = blockPos.method_10260() - worldSpawn.method_10260();
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                int maxDistance = RangesKt.coerceAtLeast((int)LevelListener.config.DistanceForMaxLevel, (int)1);
                float blendFactor = RangesKt.coerceIn((float)LevelListener.config.DistanceBlendFactor, (float)0.0f, (float)1.0f);
                float exponent = RangesKt.coerceAtLeast((float)LevelListener.config.Exponent, (float)1.0f);
                double normalizedDist = RangesKt.coerceIn((double)(distance / (double)maxDistance), (double)0.0, (double)1.0);
                double scaledFactor = Math.pow(normalizedDist, exponent);
                int distanceScaledLevel = (int)((double)minScalingLevel + scaledFactor * (double)(Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel() - minScalingLevel));
                int blendedLevel = (int)((1.0f - blendFactor) * (float)finalLevel + blendFactor * (float)distanceScaledLevel);
                int n6 = LevelListener.config.OnlyScaleUpwards ? (blendedLevel > finalLevel ? blendedLevel : finalLevel) : (finalLevel = blendedLevel);
                if (minLevel != null || maxLevel != null) {
                    finalLevel = this.applySimpleClamp(finalLevel, minLevel, maxLevel);
                }
            }
        } else if (!(LevelListener.config.EnableDistanceScaling || minLevel == null && maxLevel == null)) {
            finalLevel = this.applySimpleClamp(finalLevel, minLevel, maxLevel);
        }
        if (maxLevel != null && finalLevel > maxLevel) {
            finalLevel = maxLevel;
        }
        if (minLevel != null && finalLevel < minLevel) {
            finalLevel = minLevel;
        }
        if (finalLevel != originalLevel) {
            if (LevelListener.config.ExclusionInterval <= 1) {
                pokemon.setLevel(finalLevel);
            } else if (++scaledAmount >= LevelListener.config.ExclusionInterval) {
                scaledAmount = 0;
            } else {
                pokemon.setLevel(finalLevel);
            }
        }
    }

    public final int applySimpleClamp(int level, @Nullable Integer min, @Nullable Integer max) {
        int result = level;
        if (min != null && max != null && level < min) {
            result = this.scaleLevelToRange(level, min, max);
        } else if (min != null && level < min) {
            int onesDigit = level % 10;
            result = RangesKt.coerceAtMost((int)(min + onesDigit), (int)Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel());
        }
        if (max != null && result > max) {
            result = max;
        }
        return result;
    }

    public final int scaleLevelToRange(int level, int minLevel, int maxLevel) {
        int clampedLevel = RangesKt.coerceIn((int)level, (int)0, (int)minLevel);
        double ratio = (double)clampedLevel / (double)minLevel;
        double scaledLevel = (double)minLevel + (double)(maxLevel - minLevel) * ratio;
        return RangesKt.coerceAtMost((int)((int)scaledLevel), (int)Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getLevelMap(@NotNull List<String> entries) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Iterable $this$mapNotNull$iv = entries;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String entry = (String)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List parts = (List)destination$iv$iv2;
            if (parts.size() == 3) {
                String key = parts.get(0) + ":" + parts.get(1);
                Integer value = StringsKt.toIntOrNull((String)((String)parts.get(2)));
                pair = value != null ? TuplesKt.to((Object)key, (Object)value) : null;
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final String onPokemonSpawn$lambda$0(class_5321 it) {
        return it.method_29177().toString();
    }

    private static final String onPokemonSpawn$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        List<String> list = LevelListener.config.DimensionMinLevel;
        Intrinsics.checkNotNullExpressionValue(list, (String)"DimensionMinLevel");
        dimensionMinLevels = INSTANCE.getLevelMap(list);
        List<String> list2 = LevelListener.config.DimensionMaxLevel;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"DimensionMaxLevel");
        dimensionMaxLevels = INSTANCE.getLevelMap(list2);
        List<String> list3 = LevelListener.config.BiomeMinLevel;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"BiomeMinLevel");
        biomeMinLevels = INSTANCE.getLevelMap(list3);
        List<String> list4 = LevelListener.config.BiomeMaxLevel;
        Intrinsics.checkNotNullExpressionValue(list4, (String)"BiomeMaxLevel");
        biomeMaxLevels = INSTANCE.getLevelMap(list4);
        minScalingLevel = LevelListener.config.StartScalingOnLvl;
        maxScalingLevel = LevelListener.config.StopScalingOnLvl;
    }
}

