/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.simply_no_shading.impl.client;

import com.google.common.base.CaseFormat;
import io.github.startsmercury.simply_no_shading.api.client.Config;
import io.github.startsmercury.simply_no_shading.impl.client.GameContext;
import io.github.startsmercury.simply_no_shading.impl.client.ReloadLevel;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public enum ShadingTarget {
    BLOCK,
    CLOUD,
    ENTITY;

    private static final List<ShadingTarget> VALUE_LIST;
    private final String toggleKey;
    private final String toString = (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)this.name());

    public static List<? extends ShadingTarget> valueList() {
        return VALUE_LIST;
    }

    private ShadingTarget() {
        this.toggleKey = "toggle" + (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)this.name()) + "Shading";
    }

    public boolean getFrom(Config config) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> config.blockShadingEnabled();
            case 1 -> config.cloudShadingEnabled();
            case 2 -> config.entityShadingEnabled();
        };
    }

    public boolean changedBetween(Config lhs, Config rhs) {
        return this.getFrom(lhs) != this.getFrom(rhs);
    }

    public void setInto(Config config, boolean enabled) {
        switch (this.ordinal()) {
            case 0: {
                config.setBlockShadingEnabled(enabled);
                break;
            }
            case 1: {
                config.setCloudShadingEnabled(enabled);
                break;
            }
            case 2: {
                config.setEntityShadingEnabled(enabled);
            }
        }
    }

    public ReloadLevel reloadTypeFor(GameContext context) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (context.shadersEnabled()) {
                    yield ReloadLevel.NONE;
                }
                yield ReloadLevel.ALL_CHANGED;
            }
            case 1 -> {
                if (context.shadersEnabled()) {
                    yield ReloadLevel.NONE;
                }
                if (context.sodiumLoaded()) {
                    yield ReloadLevel.ALL_CHANGED;
                }
                yield ReloadLevel.NEEDS_UPDATE;
            }
            case 2 -> ReloadLevel.RESOURCE_PACKS;
        };
    }

    public String toggleKey() {
        return this.toggleKey;
    }

    public String toString() {
        return this.toString;
    }

    static {
        VALUE_LIST = List.of(ShadingTarget.values());
    }
}

