/*
 * Decompiled with CFR 0.152.
 */
package com.github.startsmercury.simply.no.shading.util.storage;

import com.github.startsmercury.simply.no.shading.util.storage.PathStorage;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Deprecated(since="7.0.0", forRemoval=true)
@Environment(value=EnvType.CLIENT)
public class JsonPathStorage<T>
extends PathStorage<T> {
    private static final Gson FALLBACK_GSON = new Gson();
    private final Gson gson;
    private final Type type;

    public JsonPathStorage(Path path) {
        this(path, FALLBACK_GSON, (Type)null);
    }

    public JsonPathStorage(Path path, Class<T> clazz) {
        this(path, FALLBACK_GSON, (Type)clazz);
    }

    public JsonPathStorage(Path path, Gson gson) {
        this(path, gson, (Type)null);
    }

    public JsonPathStorage(Path path, Gson gson, Class<T> clazz) {
        this(path, gson, (Type)clazz);
    }

    JsonPathStorage(Path path, Gson gson, Type type) {
        super(path);
        this.gson = gson;
        this.type = type;
    }

    public Gson getGson() {
        return this.gson;
    }

    protected final Gson getGsonElseFallback() {
        Gson gson = this.getGson();
        if (gson == null) {
            return FALLBACK_GSON;
        }
        return gson;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public T load() throws Exception {
        Path path = this.getPath();
        if (path == null) {
            throw new IllegalStateException("Unable to load when " + this.getClass().getName() + "::getPath() returns null", new NullPointerException("Source path was null"));
        }
        Type type = this.getType();
        if (type == null) {
            throw new IllegalStateException("Unable to load when " + this.getClass().getName() + "::getType() returns null", new NullPointerException("type was null"));
        }
        Gson gson = this.getGsonElseFallback();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object object = gson.fromJson((Reader)reader, type);
            return (T)object;
        }
    }

    @Override
    public void save(T obj) throws Exception {
        Path path = this.getPath();
        if (path == null) {
            throw new IllegalStateException("Unable to save when " + this.getClass().getName() + "::getPath() returns null", new NullPointerException("Destination path was null"));
        }
        Type type = this.getType();
        if (type == null) {
            throw new IllegalStateException("Unable to save when " + this.getClass().getName() + "::getType() returns null", new NullPointerException("type was null"));
        }
        Gson gson = this.getGsonElseFallback();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            gson.toJson(obj, type, (Appendable)writer);
        }
    }
}

