/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.simply_no_shading.impl.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import io.github.startsmercury.simply_no_shading.api.client.Config;
import io.github.startsmercury.simply_no_shading.api.client.SimplyNoShading;
import io.github.startsmercury.simply_no_shading.impl.client.ComputedConfig;
import io.github.startsmercury.simply_no_shading.impl.client.ConfigImpl;
import io.github.startsmercury.simply_no_shading.impl.client.GameContext;
import io.github.startsmercury.simply_no_shading.impl.client.KeyMapping;
import io.github.startsmercury.simply_no_shading.impl.client.ReloadLevel;
import io.github.startsmercury.simply_no_shading.impl.client.ShadingTarget;
import io.github.startsmercury.simply_no_shading.impl.client.gui.screens.ConfigScreen;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class SimplyNoShadingImpl
implements SimplyNoShading {
    private final ConfigImpl config = new ConfigImpl();
    private final Path configPath;
    private final GameContext context = new GameContext();
    private final FabricLoader fabricLoader = FabricLoader.getInstance();
    private SoftReference<Gson> gsonRef = new SoftReference<Object>(null);
    private final KeyMapping keyOpenModConfig = SimplyNoShadingImpl.createKeyMapping("openModConfig");
    private final KeyMapping keyReloadConfig = SimplyNoShadingImpl.createKeyMapping("reloadConfig");
    private final List<KeyMapping> keyShadingToggles = ShadingTarget.valueList().stream().map(ShadingTarget::toggleKey).map(SimplyNoShadingImpl::createKeyMapping).toList();
    private final Logger logger = LoggerFactory.getLogger((String)"Simply No Shading");
    private final class_310 minecraft;

    public SimplyNoShadingImpl(class_310 minecraft) {
        this.minecraft = minecraft;
        this.configPath = this.fabricLoader.getConfigDir().resolve("simply-no-shading.json");
    }

    public void onInitialize() {
        this.logger.debug("Initializing {}...", (Object)"Simply No Shading");
        this.loadConfig();
        this.registerKeyMappings();
        this.registerResources();
        this.registerShutdownHook();
        if (this.fabricLoader.isModLoaded("sodium")) {
            this.context.setSodiumLoaded(true);
        }
        this.logger.info("{} is initialized.", (Object)"Simply No Shading");
    }

    @Override
    @NotNull
    public Path configPath() {
        return this.configPath;
    }

    @Override
    @NotNull
    public Config config() {
        return new ConfigImpl(this.config);
    }

    @Override
    public void setConfig(@NotNull Config config) {
        this.config.set(config);
        ComputedConfig.set(config);
    }

    public GameContext context() {
        return this.context;
    }

    private Gson gson() {
        Gson gson = this.gsonRef.get();
        if (gson == null) {
            gson = new Gson();
            this.gsonRef = new SoftReference<Gson>(gson);
        }
        return gson;
    }

    public void loadConfig() {
        this.logger.debug("[{}] Loading the config...", (Object)"Simply No Shading");
        try {
            BufferedReader reader = Files.newBufferedReader(this.configPath());
            this.loadConfigHelper(reader);
        }
        catch (NoSuchFileException cause) {
            this.logger.info("[{}] Config file not present, defaults will be used.", (Object)"Simply No Shading");
        }
        catch (IOException cause) {
            this.logger.error("[{}] Unable to create config file reader.", (Object)"Simply No Shading", (Object)cause);
        }
    }

    private void loadConfigHelper(Reader reader) {
        try (Reader reader2 = reader;){
            ConfigImpl config = (ConfigImpl)this.gson().fromJson(reader, ConfigImpl.class);
            this.setConfig(config);
            this.logger.info("[{}] The config is loaded.", (Object)"Simply No Shading");
        }
        catch (JsonSyntaxException cause) {
            this.logger.error("[{}] Invalid config JSON syntax.", (Object)"Simply No Shading", (Object)cause);
        }
        catch (JsonIOException cause) {
            this.logger.error("[{}] Unable to read config JSON.", (Object)"Simply No Shading", (Object)cause);
        }
        catch (IOException cause) {
            this.logger.error("[{}] Unable to soundly close config file reader.", (Object)"Simply No Shading", (Object)cause);
        }
    }

    public void saveConfig() {
        this.logger.debug("[{}] Saving the config...", (Object)"Simply No Shading");
        Gson gson = this.gson();
        JsonObject tree = this.parseConfigAsJsonObject();
        JsonElement jsonElement = gson.toJsonTree((Object)this.config());
        if (!(jsonElement instanceof JsonObject)) {
            throw new AssertionError((Object)"Expected config to serialize as JSON object");
        }
        JsonObject overrides = (JsonObject)jsonElement;
        tree.asMap().putAll(overrides.asMap());
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.configPath(), new OpenOption[0]);
            this.saveConfigHelper(gson, tree, writer);
        }
        catch (IOException cause) {
            this.logger.error("[{}] Unable to create config file writer.", (Object)"Simply No Shading", (Object)cause);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject parseConfigAsJsonObject() {
        try (BufferedReader reader = Files.newBufferedReader(this.configPath());){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (!(jsonElement instanceof JsonObject)) return new JsonObject();
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonElement = jsonObject;
            return jsonElement;
        }
        catch (JsonParseException | IOException throwable) {
            // empty catch block
        }
        return new JsonObject();
    }

    private void saveConfigHelper(Gson gson, JsonObject tree, Writer writer) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setIndent("    ");
        try (Writer writer2 = writer;
             JsonWriter jsonWriter2 = jsonWriter;){
            this.saveConfigHelperHelper(gson, tree, jsonWriter);
        }
        catch (IOException cause) {
            this.logger.error("[{}] Unable to soundly close config file writer.", (Object)"Simply No Shading", (Object)cause);
        }
    }

    private void saveConfigHelperHelper(Gson gson, JsonObject tree, JsonWriter jsonWriter) {
        try {
            gson.toJson((JsonElement)tree, jsonWriter);
            this.logger.info("[{}] The config is saved.", (Object)"Simply No Shading");
        }
        catch (JsonIOException cause) {
            this.logger.error("[{}] Unable to write to config file.", (Object)"Simply No Shading", (Object)cause);
        }
    }

    public KeyMapping keyOpenModConfig() {
        return this.keyOpenModConfig;
    }

    public KeyMapping keyReloadConfig() {
        return this.keyReloadConfig;
    }

    public List<? extends KeyMapping> keyShadingToggles() {
        return this.keyShadingToggles;
    }

    private void registerKeyMappings() {
        if (!this.fabricLoader.isModLoaded("fabric-key-binding-api-v1") || !this.fabricLoader.isModLoaded("fabric-lifecycle-events-v1")) {
            return;
        }
        KeyBindingHelper.registerKeyBinding((class_304)this.keyOpenModConfig());
        KeyBindingHelper.registerKeyBinding((class_304)this.keyReloadConfig());
        this.keyShadingToggles().forEach(KeyBindingHelper::registerKeyBinding);
        ClientTickEvents.END_CLIENT_TICK.register(this::consumeKeyEvents);
    }

    private static KeyMapping createKeyMapping(String name) {
        return new KeyMapping("simply-no-shading.key." + name, class_3675.field_16237.method_1444(), class_304.class_11900.field_62556);
    }

    private void consumeKeyEvents(class_310 ignored) {
        if (this.keyOpenModConfig().method_1434()) {
            class_437 lastScreen = this.minecraft.field_1755;
            this.minecraft.method_1507(this.createConfigScreen(lastScreen));
        } else if (this.keyReloadConfig().method_1434()) {
            this.reloadConfig();
        } else {
            this.consumeKeyToggleEvents();
        }
    }

    public class_437 createConfigScreen(class_437 lastScreen) {
        return new ConfigScreen(lastScreen, this.config(), newConfig -> {
            Config oldConfig = this.config();
            this.setConfig((Config)newConfig);
            this.saveConfig();
            this.applyChangesBetween(oldConfig, (Config)newConfig);
        });
    }

    public void applyChangesBetween(Config lhs, Config rhs) {
        GameContext context = this.context();
        ShadingTarget.valueList().stream().filter(target -> target.changedBetween(lhs, rhs)).map(target -> target.reloadTypeFor(context)).max(Comparator.naturalOrder()).orElse(ReloadLevel.NONE).applyTo(this.minecraft);
    }

    private void reloadConfig() {
        Config oldConfig = this.config();
        this.loadConfig();
        Config newConfig = this.config();
        this.applyChangesBetween(oldConfig, newConfig);
    }

    private void consumeKeyToggleEvents() {
        GameContext context = this.context();
        if (this.context().shadersEnabled()) {
            this.keyShadingToggles().forEach(KeyMapping::consumeAction);
            return;
        }
        Config config = this.config();
        List<KeyMapping> keyShadingToggles = this.keyShadingToggles;
        ReloadLevel reloadType = ShadingTarget.valueList().stream().filter(target -> ((KeyMapping)((Object)((Object)keyShadingToggles.get(target.ordinal())))).consumeReleased()).peek(target -> target.setInto(config, !target.getFrom(config))).map(target -> target.reloadTypeFor(context)).max(Comparator.naturalOrder()).orElse(null);
        if (reloadType != null) {
            this.setConfig(config);
            ComputedConfig.set(config);
            reloadType.applyTo(this.minecraft);
        }
    }

    private void registerResources() {
        if (!this.fabricLoader.isModLoaded("fabric-resource-loader-v0")) {
            return;
        }
        ModContainer container = (ModContainer)this.fabricLoader.getModContainer("simply-no-shading").orElseThrow(() -> new AssertionError((Object)"    Fabric mod container for ${MODID} does not exist. Developer might have used a     different mod id from the one in fabric.mod.json. Please create an issue in their     repository.".replace("${MODID}", "simply-no-shading")));
        boolean success = ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"simply-no-shading", (String)"simply_no_entity_like_shading"), (ModContainer)container, (class_2561)class_2561.method_43470((String)"Entity(ish) No Shading"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        if (!success) {
            this.logger.warn("[{}] Unable to register built-in resource pack {}", (Object)"Simply No Shading", (Object)"simply_no_entity_like_shading");
        }
    }

    private void registerShutdownHook() {
        Thread shutdownThread = new Thread(this::saveConfig);
        shutdownThread.setName("Simply No Shading Shutdown Thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

