/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.simply_no_shading.impl.client.gui.screens;

import io.github.startsmercury.simply_no_shading.impl.client.config.v1.Config;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigData;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigPreset;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_339;
import net.minecraft.class_353;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ConfigScreen
extends class_4667 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"simply-no-shading.config.title");
    private static final class_2561 QUALITY_HEADER = class_2561.method_43471((String)"simply-no-shading.config.general.header");
    private static final class_2561 PREFERENCES_HEADER = class_2561.method_43471((String)"simply-no-shading.config.preferences.header");
    private final Consumer<? super Config> configCallback;
    private ConfigPreset preset;
    private boolean compatibilityMode;
    private Optional<Data> custom;

    public ConfigScreen(@Nullable class_437 lastScreen, Config initialConfig, Consumer<? super Config> configCallback) {
        super(lastScreen, class_310.method_1551().field_1690, TITLE);
        Objects.requireNonNull(initialConfig, "Parameter initialConfig is null");
        this.preset = initialConfig.preset();
        this.compatibilityMode = initialConfig.compatibilityMode();
        this.custom = initialConfig.custom().map(Data::new);
        this.configCallback = configCallback;
    }

    public void method_25432() {
        this.configCallback.accept(new Config(this.compatibilityMode, this.preset, this.custom.map(Data::build)));
    }

    protected void method_60325() {
        class_353 list = this.field_51824;
        assert (list != null);
        ConfigData data = this.custom.map(Data::build).orElse(ConfigData.DEFAULT);
        class_7172<Boolean> shadeBlocks = this.createBoolean("shadeBlocks", data.shadeBlocks(), b -> {
            this.getOrCreateCustom().shadeBlocks = b;
        });
        class_7172<Boolean> shadeClouds = this.createBoolean("shadeClouds", data.shadeClouds(), b -> {
            this.getOrCreateCustom().shadeClouds = b;
        });
        class_7172<Boolean> shadeEntities = this.createBoolean("shadeEntities", data.shadeEntities(), b -> {
            this.getOrCreateCustom().shadeEntities = b;
        });
        class_7172 preset = new class_7172("simply-no-shading.config.preset", class_7172.method_42717((class_2561)class_2561.method_43471((String)"simply-no-shading.config.preset.tooltip")), (component, p) -> class_315.method_41783((class_2561)component, (class_2561)class_2561.method_43471((String)("simply-no-shading.config.preset." + p.name().toLowerCase(Locale.ROOT)))), (class_7172.class_7178)new class_7172.class_12139(ConfigPreset.valueList(), ConfigPreset.CODEC), ConfigPreset.CODEC, (Object)this.preset, p -> {
            this.preset = p;
            this.presetChanged(list, shadeBlocks, shadeClouds, shadeEntities, (ConfigPreset)((Object)p));
        });
        list.method_75365(QUALITY_HEADER);
        list.method_20408(new class_7172[]{this.createBoolean("compatibilityMode", this.compatibilityMode, b -> {
            this.compatibilityMode = b;
        })});
        list.method_75365(PREFERENCES_HEADER);
        list.method_20406(preset);
        list.method_20408(new class_7172[]{shadeBlocks, shadeClouds});
        list.method_20408(new class_7172[]{shadeEntities});
        this.presetChanged(list, shadeBlocks, shadeClouds, shadeEntities, this.preset);
    }

    private Data getOrCreateCustom() {
        return this.custom.orElseGet(() -> {
            Data custom = new Data(this.preset.override().orElse(ConfigData.DEFAULT));
            this.custom = Optional.of(custom);
            return custom;
        });
    }

    private void presetChanged(class_353 list, class_7172<Boolean> shadeBlocks, class_7172<Boolean> shadeClouds, class_7172<Boolean> shadeEntities, ConfigPreset preset) {
        class_339 shadeBlocksWidget = list.method_31046(shadeBlocks);
        class_339 shadeCloudsWidget = list.method_31046(shadeClouds);
        class_339 shadeEntitiesWidget = list.method_31046(shadeEntities);
        if (shadeBlocksWidget == null || shadeCloudsWidget == null || shadeEntitiesWidget == null) {
            return;
        }
        preset.override().or(() -> this.custom.map(Data::build)).ifPresent(data -> {
            ConfigScreen.trySetWidget(shadeBlocksWidget, data.shadeBlocks());
            ConfigScreen.trySetWidget(shadeCloudsWidget, data.shadeClouds());
            ConfigScreen.trySetWidget(shadeEntitiesWidget, data.shadeEntities());
        });
        shadeCloudsWidget.field_22763 = shadeBlocksWidget.field_22763 = preset.override().isEmpty();
        shadeEntitiesWidget.field_22763 = shadeBlocksWidget.field_22763;
    }

    private static <T> void trySetWidget(class_339 widget, T value) {
        if (widget instanceof class_5676) {
            class_5676 button;
            class_5676 unchecked = button = (class_5676)widget;
            unchecked.method_32605(value);
        }
    }

    private class_7172<Boolean> createBoolean(String id, boolean initial, Consumer<Boolean> setter) {
        String key = "simply-no-shading.config." + id;
        class_7919 tooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)(key + ".tooltip")));
        return class_7172.method_41750((String)key, b -> tooltip, (boolean)initial, setter);
    }

    @Environment(value=EnvType.CLIENT)
    private static class Data {
        private boolean shadeBlocks;
        private boolean shadeClouds;
        private boolean shadeEntities;

        public Data(ConfigData data) {
            this.shadeBlocks = data.shadeBlocks();
            this.shadeClouds = data.shadeClouds();
            this.shadeEntities = data.shadeEntities();
        }

        public ConfigData build() {
            return new ConfigData(this.shadeBlocks, this.shadeClouds, this.shadeEntities);
        }
    }
}

