package com.github.startsmercury.simply.no.shading.entrypoint;

import static net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper.registerKeyBinding;

import com.github.startsmercury.simply.no.shading.client.Config;
import com.github.startsmercury.simply.no.shading.client.SimplyNoShading;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_4666;

/**
 * The {@code SimplyNoShadingClientEntrypoint} class is an implementation of
 * {@link ClientModInitializer} and is an entrypoint defined with the
 * {@code client} key in the {@code fabric.mod.json}. This allows Simply No
 * Shading to be initialized and configured for the minecraft client.
 *
 * @since 6.0.0
 * @deprecated No replacement
 */
@Deprecated(since = "7.0.0", forRemoval = true)
@SuppressWarnings({ "all", "removal" })
public class SimplyNoShadingClientEntrypoint implements ClientModInitializer {
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onInitializeClient() {
		final var simplyNoShading = new SimplyNoShading();

		simplyNoShading.loadConfig();

		setupKeyMappings(simplyNoShading);
		setupResources();
		setupShutdownHook(simplyNoShading::saveConfig);
	}

	/**
	 * Registers key mappings and key event listeners.
	 *
	 * @param simplyNoShading the simply no shading instance
	 */
	protected void setupKeyMappings(final SimplyNoShading simplyNoShading) {
		final var openConfigScreen = new class_304("simply-no-shading.key.openConfigScreen",
		        class_3675.field_16237.method_1444(),
		        "simply-no-shading.key.categories.simply-no-shading");
		final var reloadConfig = new class_304("simply-no-shading.key.reloadConfig",
		        class_3675.field_16237.method_1444(),
		        "simply-no-shading.key.categories.simply-no-shading");
		final var toggleBlockShading = new class_4666("simply-no-shading.key.toggleBlockShading",
		        class_3675.field_16237.method_1444(),
		        "simply-no-shading.key.categories.simply-no-shading",
		        () -> simplyNoShading.getConfig().blockShadingEnabled);
		final var toggleCloudShading = new class_4666("simply-no-shading.key.toggleCloudShading",
		        class_3675.field_16237.method_1444(),
		        "simply-no-shading.key.categories.simply-no-shading",
		        () -> simplyNoShading.getConfig().blockShadingEnabled);

		registerKeyBinding(openConfigScreen);
		registerKeyBinding(reloadConfig);
		registerKeyBinding(toggleBlockShading);
		registerKeyBinding(toggleCloudShading);

		ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
			if (reloadConfig.method_1436()) {
				while (reloadConfig.method_1436()) {}

				simplyNoShading.loadConfig();
			}

			if (openConfigScreen.method_1436()) {
				while (openConfigScreen.method_1436()) {}

				// minecraft.setScreen(new ConfigScreen(null));
				return;
			}

			final var builder = Config.builder(simplyNoShading.getConfig());

			while (toggleBlockShading.method_1436())
				builder.setBlockShadingEnabled(!builder.isBlockShadingEnabled());
			while (toggleCloudShading.method_1436())
				builder.setCloudShadingEnabled(!builder.isCloudShadingEnabled());

			simplyNoShading.setConfig(builder.build());
		});
	}

	/**
 	 * Registers resources such as built-in resource packs.
   	 */
	protected void setupResources() {
		FabricLoader.getInstance().getModContainer("simply-no-shading").ifPresent(container -> {
			ResourceManagerHelper.registerBuiltinResourcePack(
				class_2960.method_60655("simply-no-shading", "simply_no_entity_like_shading"),
				container,
				ResourcePackActivationType.NORMAL
			);
		});
	}

	/**
	 * Registers a shutdown thread with the name 'Simply No Shading Shutdown Thread'
	 *
	 * @param shutdownAction the shutdown action to run
	 */
	protected void setupShutdownHook(final Runnable shutdownAction) {
		final var shutdownThread = new Thread(shutdownAction);
		shutdownThread.setName("Simply No Shading Shutdown Thread");
		Runtime.getRuntime().addShutdownHook(shutdownThread);
	}
}
