package io.github.startsmercury.simply_no_shading.impl.client.death_protection;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.startsmercury.simply_no_shading.impl.client.ShaderPreprocessor;
import io.github.startsmercury.simply_no_shading.impl.client.SimplyNoShadingImpl;
import io.github.startsmercury.simply_no_shading.impl.client.SnsConstants;
import io.github.startsmercury.simply_no_shading.impl.client.extension.MaterialAltRenderType;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5944;

/**
 * Totem of Undying use animation support.
 * <p>
 * The animation is considered a GUI element and thus not applicable under
 * {@link ShaderPreprocessor#CONDITIONAL}. A copy of the rendering objects are
 * handled here and among the sibling classes.
 */
public final class DeathProtectionFeature {
    public static class_4588 modifyBufferRenderType(
        final class_4730 instance,
        final class_4597 multiBufferSource,
        final Function<class_2960, class_1921> renderType,
        final Operation<class_4588> original
    ) {
        final var minecraft = class_310.method_1551();
        final var simplyNoShading = minecraft.getSimplyNoShading();

        if (!simplyNoShading.config().entityShadingEnabled()) {
            final var simplyNoShadingImpl = (SimplyNoShadingImpl) simplyNoShading;

            if (simplyNoShadingImpl.context().itemActivationItem()) {
                MaterialAltRenderType.altRenderType(instance);
                final var result = original.call(instance, multiBufferSource, renderType.compose(DeathProtectionFeature::tryMangle));
                MaterialAltRenderType.altRenderType(instance);
                return result;
            }
        }

        return original.call(instance, multiBufferSource, renderType);
    }

    public static class_4588 modifyBufferRenderType(
        final class_4730 instance,
        final class_4597 multiBufferSource,
        final Function<class_2960, class_1921> renderType,
        final boolean bl,
        final Operation<class_4588> original
    ) {
        final var minecraft = class_310.method_1551();
        final var simplyNoShading = minecraft.getSimplyNoShading();

        if (!simplyNoShading.config().entityShadingEnabled()) {
            final var simplyNoShadingImpl = (SimplyNoShadingImpl) simplyNoShading;

            if (simplyNoShadingImpl.context().itemActivationItem()) {
                MaterialAltRenderType.altRenderType(instance);
                final var result = original.call(instance, multiBufferSource, renderType.compose(DeathProtectionFeature::tryMangle), bl);
                MaterialAltRenderType.altRenderType(instance);
                return result;
            }
        }

        return original.call(instance, multiBufferSource, renderType, bl);
    }

    public static class_2960 tryMangle(final class_2960 original) {
        final var minecraft = class_310.method_1551();
        final var simplyNoShading = minecraft.getSimplyNoShading();
        if (simplyNoShading.config().entityShadingEnabled()) return original;

        final var simplyNoShadingImpl = (SimplyNoShadingImpl) simplyNoShading;
        if (!simplyNoShadingImpl.context().itemActivationItem()) return original;

        return DeathProtectionFeature.mangle(original);
    }

    public static class_2960 mangle(final class_2960 resourceLocation) {
        return class_2960.method_60655(SnsConstants.MODID, resourceLocation.method_12832());
    }

    public static class_1921 modifyItemRenderType(
        final SimplyNoShadingImpl simplyNoShading,
        final class_1921 original
    ) {
        if (original == class_4722.method_24076()) {
            return SnsSheets.translucentCullBlockSheet();
        } else if (original == class_4722.method_29382()) {
            return SnsSheets.translucentItemSheet();
        } else if (original == class_4722.method_24074()) {
            return SnsSheets.cutoutBlockSheet();
        } else {
            handleUnexpectedRenderType(simplyNoShading, original);
            return original;
        }
    }

    private static ReferenceSet<class_1921> unknowns;

    private static void handleUnexpectedRenderType(
        final SimplyNoShadingImpl simplyNoShading,
        final class_1921 renderType
    ) {
        var unknowns = DeathProtectionFeature.unknowns;

        if (unknowns == null) {
            synchronized (DeathProtectionFeature.class) {
                unknowns = DeathProtectionFeature.unknowns;

                if (unknowns == null) {
                    DeathProtectionFeature.unknowns = unknowns = new ReferenceOpenHashSet<>();

                    final var player = class_310.method_1551().field_1724;

                    if (player != null) {
                        final var message =
                            "[" + SnsConstants.NAME + "]: Detected unexpected render type (see logs)";
                        player.method_43496(
                            class_2561.method_43470(message)
                                .method_27694(style -> style.method_10977(class_124.field_1061))
                        );
                    }
                }
            }
        }

        if (unknowns.add(renderType)) {
            final var logger = simplyNoShading.logger();
            if (logger.isWarnEnabled()) {
                logger
                    .atWarn()
                    .setCause(new AssertionError("Unexpected render type"))
                    .setMessage("[" + SnsConstants.NAME + "] " + renderType)
                    .log();
            }
        }
    }

    public static class_5944 rendertypeEntitySolidShader;
    public static class_5944 rendertypeEntityCutoutShader;
    public static class_5944 rendertypeEntityCutoutNoCullShader;
    public static class_5944 rendertypeEntityCutoutNoCullZOffsetShader;
    public static class_5944 rendertypeItemEntityTranslucentCullShader;
    public static class_5944 rendertypeEntityTranslucentCullShader;
    public static class_5944 rendertypeEntityNoOutlineShader;

    public static class_5944 getRendertypeEntitySolidShader() {
        return rendertypeEntitySolidShader;
    }

    public static class_5944 getRendertypeEntityCutoutShader() {
        return rendertypeEntityCutoutShader;
    }

    public static class_5944 getRendertypeEntityCutoutNoCullShader() {
        return rendertypeEntityCutoutNoCullShader;
    }

    public static class_5944 getRendertypeEntityCutoutNoCullZOffsetShader() {
        return rendertypeEntityCutoutNoCullZOffsetShader;
    }

    public static class_5944 getRendertypeItemEntityTranslucentCullShader() {
        return rendertypeItemEntityTranslucentCullShader;
    }

    public static class_5944 getRendertypeEntityTranslucentCullShader() {
        return rendertypeEntityTranslucentCullShader;
    }

    public static class_5944 getRendertypeEntityNoOutlineShader() {
        return rendertypeEntityNoOutlineShader;
    }

    private DeathProtectionFeature() {}
}
