package io.github.startsmercury.simply_no_shading.mixin.client.shading.death_protection;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import io.github.startsmercury.simply_no_shading.impl.client.SimplyNoShadingImpl;
import io.github.startsmercury.simply_no_shading.impl.client.death_protection.DeathProtectionFeature;
import io.github.startsmercury.simply_no_shading.impl.client.death_protection.ResourceProviderWrapper;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_757.class)
public class GameRendererMixin {
    @Final
    @Shadow
    class_310 minecraft;

    @Inject(
        method = "renderItemActivationAnimation",
        at = @At(
            value = "INVOKE",
            target = "Lcom/mojang/blaze3d/vertex/PoseStack;<init>()V"
        )
    )
    private void onRenderItemActivationAnimationStart(final CallbackInfo callback) {
        final var simplyNoShading = (SimplyNoShadingImpl) this.minecraft.getSimplyNoShading();
        simplyNoShading.context().setItemActivationItem(true);
    }

    @Inject(
        method = "renderItemActivationAnimation",
        at = @At(
            value = "INVOKE",
            shift = At.Shift.AFTER,
            target = "Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V"
        )
    )
    private void onRenderItemActivationAnimationEnd(final CallbackInfo callback) {
        final var simplyNoShading = (SimplyNoShadingImpl) this.minecraft.getSimplyNoShading();
        simplyNoShading.context().setItemActivationItem(false);
    }

    @Inject(
        method = "reloadShaders(Lnet/minecraft/server/packs/resources/ResourceProvider;)V",
        at = @At(
            value = "INVOKE",
            slice = "after_rendertype_entity_translucent_cull",
            shift = At.Shift.AFTER,
            target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
            ordinal = 0
        ),
        slice = @Slice(
            id = "after_rendertype_entity_translucent_cull",
            from = @At(value = "CONSTANT", args = "stringValue=rendertype_entity_translucent_cull")
        )
    )
    private void withReloadShader(
        final CallbackInfo callback,
        final @Local(ordinal = 0, argsOnly = true) class_5912 resourceProvider,
        final @Local(ordinal = 1) List<Pair<class_5944, Consumer<class_5944>>> list2
    ) throws IOException {
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_solid",
                class_290.field_1580
            ),
            shaderInstance -> DeathProtectionFeature.rendertypeEntitySolidShader = shaderInstance
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_cutout",
                class_290.field_1580
            ),
            shaderInstance -> DeathProtectionFeature.rendertypeEntityCutoutShader = shaderInstance
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_cutout_no_cull",
                class_290.field_1580
            ),
            shaderInstance -> {
                DeathProtectionFeature.rendertypeEntityCutoutNoCullShader = shaderInstance;
            }
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_cutout_no_cull_z_offset",
                class_290.field_1580
            ),
            shaderInstance -> {
                DeathProtectionFeature.rendertypeEntityCutoutNoCullZOffsetShader = shaderInstance;
            }
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_item_entity_translucent_cull",
                class_290.field_1580
            ),
            shaderInstance -> {
                DeathProtectionFeature.rendertypeItemEntityTranslucentCullShader = shaderInstance;
            }
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_translucent_cull",
                class_290.field_1580
            ),
            shaderInstance -> {
                DeathProtectionFeature.rendertypeEntityTranslucentCullShader = shaderInstance;
            }
        ));
        list2.add(Pair.of(
            new class_5944(
                new ResourceProviderWrapper(resourceProvider),
                "rendertype_entity_no_outline",
                class_290.field_1580
            ),
            shaderInstance -> {
                DeathProtectionFeature.rendertypeEntityNoOutlineShader = shaderInstance;
            }
        ));
    }
}
