package io.github.startsmercury.simply_no_shading.mixin.client.shading.block.minecraft;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_777;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Environment(EnvType.CLIENT)
@Mixin(class_777.class)
public abstract class BakedQuadMixin {
    private BakedQuadMixin() {
    }

    @ModifyReturnValue(method = "shade()Z", at = @At("RETURN"))
    private boolean modifyShade(final boolean original) {
        // This usually only gets called during meshing; hopefully not every frame
        final var config = class_310.method_1551().getSimplyNoShading().getConfig();

        if (config.compatibilityMode()) {
            // Injecting into ClientLevel.getShade may not be sufficient, thus:
            return original && config.data().shadeBlocks();
        } else {
            return original;
        }
    }
}
