package io.github.startsmercury.simply_no_shading.impl.client.gui.screens;

import io.github.startsmercury.simply_no_shading.impl.client.config.v1.Config;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigData;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigPreset;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_339;
import net.minecraft.class_353;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public final class ConfigScreen extends class_4667 {
    private static class Data {
        private boolean shadeBlocks;
        private boolean shadeClouds;
        private boolean shadeEntities;

        public Data(final ConfigData data) {
            this.shadeBlocks = data.shadeBlocks();
            this.shadeClouds = data.shadeClouds();
            this.shadeEntities = data.shadeEntities();
        }

        public ConfigData build() {
            return new ConfigData(this.shadeBlocks, this.shadeClouds, this.shadeEntities);
        }
    }

    private static final class_2561 TITLE = class_2561.method_43471("simply-no-shading.config.title");
    private static final class_2561 QUALITY_HEADER = class_2561.method_43471("simply-no-shading.config.general.header");
    private static final class_2561 PREFERENCES_HEADER = class_2561.method_43471("simply-no-shading.config.preferences.header");

    private final Consumer<? super Config> configCallback;

    private ConfigPreset preset;
    private boolean compatibilityMode;
    private Optional<Data> custom;

    public ConfigScreen(
        final @Nullable class_437 lastScreen,
        final Config initialConfig,
        final Consumer<? super Config> configCallback
    ) {
        //noinspection DataFlowIssue there was a mistake, lastScreen IS Nullable
        super(lastScreen, class_310.method_1551().field_1690, ConfigScreen.TITLE);

        Objects.requireNonNull(initialConfig, "Parameter initialConfig is null");

        this.preset = initialConfig.preset();
        this.compatibilityMode = initialConfig.compatibilityMode();
        this.custom = initialConfig.custom().map(Data::new);

        this.configCallback = configCallback;
    }

    @Override
    public void method_25432() {
        this.configCallback.accept(new Config(
            this.compatibilityMode,
            this.preset,
            this.custom.map(Data::build)));
    }

    @Override
    protected void method_60325() {
        final var list = this.field_51824;
        assert list != null;

        final var data = this.custom.map(Data::build).orElse(ConfigData.DEFAULT);

        final var shadeBlocks = this.createBoolean("shadeBlocks", data.shadeBlocks(), b -> this.getOrCreateCustom().shadeBlocks = b);
        final var shadeClouds = this.createBoolean("shadeClouds", data.shadeClouds(), b -> this.getOrCreateCustom().shadeClouds = b);
        final var shadeEntities = this.createBoolean("shadeEntities", data.shadeEntities(), b -> this.getOrCreateCustom().shadeEntities = b);

        final var preset = new class_7172<>(
            "simply-no-shading.config.preset",
            class_7172.method_42717(
                class_2561.method_43471("simply-no-shading.config.preset.tooltip")
            ),
            (component, p) -> class_315.method_41783(
                component,
                class_2561.method_43471(
                    "simply-no-shading.config.preset."
                        + p.name().toLowerCase(Locale.ROOT)
                )
            ),
            new class_7172.class_12139<>(ConfigPreset.valueList(), ConfigPreset.CODEC),
            ConfigPreset.CODEC,
            this.preset,
            p -> {
                this.preset = p;
                this.presetChanged(list, shadeBlocks, shadeClouds, shadeEntities, p);
            }
        );

        list.method_75365(QUALITY_HEADER);
        list.method_20408(this.createBoolean(
            "compatibilityMode",
            this.compatibilityMode,
            b -> this.compatibilityMode = b
        ));

        list.method_75365(PREFERENCES_HEADER);
        list.method_20406(preset);
        list.method_20408(shadeBlocks, shadeClouds);
        list.method_20408(shadeEntities);

        this.presetChanged(list, shadeBlocks, shadeClouds, shadeEntities, this.preset);
    }

    private Data getOrCreateCustom() {
        return this.custom.orElseGet(() -> {
            final var custom = new Data(this.preset.override().orElse(ConfigData.DEFAULT));
            this.custom = Optional.of(custom);
            return custom;
        });
    }

    private void presetChanged(
        final class_353 list,
        final class_7172<Boolean> shadeBlocks,
        final class_7172<Boolean> shadeClouds,
        final class_7172<Boolean> shadeEntities,
        final ConfigPreset preset
    ) {
        final var shadeBlocksWidget = list.method_31046(shadeBlocks);
        final var shadeCloudsWidget = list.method_31046(shadeClouds);
        final var shadeEntitiesWidget = list.method_31046(shadeEntities);

        if (shadeBlocksWidget == null ||
            shadeCloudsWidget == null ||
            shadeEntitiesWidget == null
        ) return;

        preset.override().or(() -> this.custom.map(Data::build)).ifPresent(data -> {
            trySetWidget(shadeBlocksWidget, data.shadeBlocks());
            trySetWidget(shadeCloudsWidget, data.shadeClouds());
            trySetWidget(shadeEntitiesWidget, data.shadeEntities());
        });

        shadeEntitiesWidget.field_22763 = // 3
            shadeCloudsWidget.field_22763 = // 2
                shadeBlocksWidget.field_22763 = // 1
                    preset.override().isEmpty(); // 0
    }

    private static <T> void trySetWidget(final class_339 widget, final T value) {
        if (widget instanceof final class_5676<?> button) {
            @SuppressWarnings("unchecked")
            final var unchecked = (class_5676<T>) button;
            unchecked.method_32605(value);
        }
    }

    private class_7172<Boolean> createBoolean(
        final String id,
        final boolean initial,
        final Consumer<Boolean> setter
    ) {
        final var key = "simply-no-shading.config." + id;
        final var tooltip = class_7919.method_47407(class_2561.method_43471(key + ".tooltip"));
        return class_7172.method_41750(key, b -> tooltip, initial, setter);
    }
}
