/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.simply_no_shading.impl.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.github.startsmercury.simply_no_shading.impl.client.GameContext;
import io.github.startsmercury.simply_no_shading.impl.client.KeyMapping;
import io.github.startsmercury.simply_no_shading.impl.client.ReloadLevel;
import io.github.startsmercury.simply_no_shading.impl.client.SnsConstants;
import io.github.startsmercury.simply_no_shading.impl.client.config.IConfig;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.Config;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigData;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigPreset;
import io.github.startsmercury.simply_no_shading.impl.client.extension.SnsConfigDataAware;
import io.github.startsmercury.simply_no_shading.impl.client.gui.screens.ConfigScreen;
import io.github.startsmercury.simply_no_shading.mixin.client.accessor.BlockRenderDispatcherAccessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class SimplyNoShadingImpl {
    public static final class_304.class_11900 KEY_MAPPING_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"simply-no-shading", (String)"simply-no-shading"));
    private static final Config DEFAULT_CONFIG = new Config(true, ConfigPreset.VANILLA, Optional.empty());
    public static final ConfigData DEFAULT_CONFIG_DATA = DEFAULT_CONFIG.data();
    private final GameContext context;
    private final FabricLoader fabricLoader;
    private final KeyMapping keyOpenModConfig;
    private final KeyMapping keyReloadConfig;
    private final KeyMapping keyToggleBlockShading;
    private final KeyMapping keyToggleCloudShading;
    private final KeyMapping keyToggleEntityShading;
    private final Logger logger;
    private final class_310 minecraft;
    private Config config = DEFAULT_CONFIG;

    public SimplyNoShadingImpl(class_310 minecraft) {
        this.context = new GameContext();
        this.fabricLoader = FabricLoader.getInstance();
        this.keyOpenModConfig = SimplyNoShadingImpl.createKeyMapping("openModConfig");
        this.keyReloadConfig = SimplyNoShadingImpl.createKeyMapping("reloadConfig");
        this.keyToggleBlockShading = SimplyNoShadingImpl.createKeyMapping("toggleBlockShading");
        this.keyToggleCloudShading = SimplyNoShadingImpl.createKeyMapping("toggleCloudShading");
        this.keyToggleEntityShading = SimplyNoShadingImpl.createKeyMapping("toggleEntityShading");
        this.logger = LoggerFactory.getLogger((String)"Simply No Shading");
        this.minecraft = minecraft;
    }

    public void onInitialize() {
        this.logger.debug("Initializing {}...", (Object)"Simply No Shading");
        this.setConfig(this.loadConfig().orElse(Config.DEFAULT));
        this.minecraft.method_63588(() -> this.syncConfigFor(this.config, ReloadLevel.ALL_CHANGED));
        this.registerKeyMappings();
        this.registerShutdownHook();
        if (this.fabricLoader.isModLoaded("bedrockify")) {
            this.context.setBedrockifyLoaded(true);
        }
        if (this.fabricLoader.isModLoaded("sodium")) {
            this.context.setSodiumLoaded(true);
        }
        this.logger.info("{} is initialized.", (Object)"Simply No Shading");
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfigAndReload(Config config) {
        Config oldConfig = this.setConfig(config);
        GameContext context = this.getContext();
        ReloadLevel reloadLevel = SimplyNoShadingImpl.getReloadLevel(oldConfig, config, context);
        this.syncConfigFor(config, reloadLevel);
        reloadLevel.applyTo(this.minecraft);
    }

    private Config setConfig(Config config) {
        Config oldConfig = this.config;
        this.config = config;
        return oldConfig;
    }

    private static ReloadLevel getReloadLevel(Config oldConfig, Config newConfig, GameContext context) {
        ReloadLevel reloadLevel = oldConfig.data().shadeEntities() != newConfig.data().shadeEntities() ? ReloadLevel.RESOURCE_PACKS : (context.isShadersEnabled() ? ReloadLevel.NONE : (oldConfig.data().shadeBlocks() != newConfig.data().shadeBlocks() ? ReloadLevel.ALL_CHANGED : (oldConfig.data().shadeClouds() != newConfig.data().shadeClouds() ? (context.isSodiumLoaded() ? ReloadLevel.ALL_CHANGED : ReloadLevel.NEEDS_UPDATE) : ReloadLevel.NONE)));
        return reloadLevel;
    }

    private void syncConfigFor(Config config, ReloadLevel reloadLevel) {
        ConfigData data = config.data();
        switch (reloadLevel) {
            case RESOURCE_PACKS: 
            case ALL_CHANGED: {
                class_638 level = this.minecraft.field_1687;
                if (level != null) {
                    ((SnsConfigDataAware)level).simply_no_shading$setConfigData(data);
                }
                ((SnsConfigDataAware)((BlockRenderDispatcherAccessor)this.minecraft.method_1541()).getLiquidBlockRenderer()).simply_no_shading$setConfigData(data);
                if (this.context.isBedrockifyLoaded()) {
                    ((SnsConfigDataAware)BedrockifyClient.getInstance().bedrockBlockShading).simply_no_shading$setConfigData(data);
                }
            }
            case NEEDS_UPDATE: {
                if (!config.compatibilityMode() && this.context.isSodiumLoaded()) break;
                ((SnsConfigDataAware)this.minecraft.field_1769.method_62196()).simply_no_shading$setConfigData(data);
            }
        }
    }

    public GameContext getContext() {
        return this.context;
    }

    public void openConfigFile() {
        this.logger.debug("[{}] Opening config...", (Object)"Simply No Shading");
        class_156.method_668().method_672(this.getConfigFile());
    }

    public void reloadConfig() {
        this.loadConfig().ifPresentOrElse(config -> {
            this.setConfigAndReload((Config)config);
            this.saveConfig();
        }, this::openConfigFile);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Config> loadConfig() {
        JsonObject object;
        JsonElement json;
        ArrayList lines;
        this.logger.debug("[{}] Loading the config...", (Object)"Simply No Shading");
        Path path = this.getConfigPath();
        try (Stream<String> lineStream = Files.lines(path);){
            lines = lineStream.filter(line -> !line.endsWith("@simply-no-shading::ignored")).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (NoSuchFileException cause) {
            this.logger.info("[{}] Config does not exist, using default", (Object)"Simply No Shading");
            return Optional.of(Config.DEFAULT);
        }
        catch (IOException cause) {
            this.logger.warn("[{}] Unable to read config json", (Object)"Simply No Shading", (Object)cause);
            return Optional.of(Config.DEFAULT);
        }
        try {
            json = JsonParser.parseString((String)String.join((CharSequence)"\n", lines));
        }
        catch (JsonParseException cause) {
            this.logger.warn("[{}] Invalid config json syntax", (Object)"Simply No Shading", (Object)cause);
            Matcher lineMatcher = SnsConstants.LINE_PATTERN.matcher(cause.getMessage());
            int line2 = 0;
            if (lineMatcher.find()) {
                String capturedLine = lineMatcher.group(1);
                try {
                    line2 = Integer.parseInt(capturedLine);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            StringBuilder errorMessageBuilder = new StringBuilder();
            Matcher columnMatcher = SnsConstants.COLUMN_PATTERN.matcher(cause.getMessage());
            if (columnMatcher.find()) {
                try {
                    String capturedColumn = columnMatcher.group(1);
                    int column = Integer.parseInt(capturedColumn);
                    if (column >= 2) {
                        errorMessageBuilder.append(" ".repeat(column - 2));
                    }
                    errorMessageBuilder.append("^ ");
                }
                catch (NumberFormatException capturedColumn) {
                    // empty catch block
                }
            }
            errorMessageBuilder.append(cause.getMessage()).append("\t").append("@simply-no-shading::ignored");
            lines.add(line2, errorMessageBuilder);
            try {
                Files.write(path, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
                return Optional.empty();
            }
            catch (IOException cause2) {
                this.logger.warn("[{}] Unable to update config json with an error message", (Object)"Simply No Shading", (Object)cause2);
            }
            return Optional.empty();
        }
        if (json instanceof JsonObject && !(object = (JsonObject)json).has("version")) {
            object.addProperty("version", (Number)0);
        }
        DataResult dataResult = IConfig.LENIENT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst).map(IConfig::upgrade);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        block28: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int n2;
                    DataResult dataResult3;
                    DataResult.Success success = (DataResult.Success)dataResult2;
                    try {
                        dataResult3 = (DataResult)success.value();
                        n2 = 0;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult3, n2)) {
                        case 0: {
                            DataResult.Success success2 = (DataResult.Success)dataResult3;
                            {
                                Lifecycle lifecycle;
                                Lifecycle _0 = lifecycle = success.lifecycle();
                            }
                            return Optional.of((Config)success2.value());
                        }
                        case 1: {
                            DataResult.Error error = (DataResult.Error)dataResult3;
                            {
                                Lifecycle lifecycle;
                                Lifecycle _0 = lifecycle = success.lifecycle();
                            }
                            if (!this.logger.isWarnEnabled()) return Optional.empty();
                            this.logger.atWarn().log(() -> "[Simply No Shading] Unable to upgrade config: " + error.message());
                            return Optional.empty();
                        }
                    }
                    n = 1;
                    continue block28;
                }
                case 1: 
            }
            break;
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        if (!this.logger.isWarnEnabled()) return Optional.empty();
        this.logger.atWarn().log(() -> "[Simply No Shading] Unable to decode config: " + error.message());
        return Optional.empty();
    }

    public void saveConfig() {
        JsonObject json;
        this.logger.debug("[{}] Saving config...", (Object)"Simply No Shading");
        Path path = this.fabricLoader.getConfigDir().resolve("simply-no-shading.json");
        DataResult dataResult = IConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.config);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                json = (JsonObject)success.value();
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                if (this.logger.isWarnEnabled()) {
                    this.logger.atWarn().log(() -> "[Simply No Shading] Unable to encode config: " + error.message());
                }
                return;
            }
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
             JsonWriter jsonWriter = new JsonWriter((Writer)bufferedWriter);){
            jsonWriter.setIndent("    ");
            class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)json, Comparator.naturalOrder());
            bufferedWriter.newLine();
        }
        catch (IOException cause) {
            this.logger.warn("[{}] Unable to write config json", (Object)"Simply No Shading", (Object)cause);
        }
    }

    private Path getConfigPath() {
        return this.fabricLoader.getConfigDir().resolve("simply-no-shading.json");
    }

    public File getConfigFile() {
        return this.getConfigPath().toFile();
    }

    public KeyMapping keyOpenModConfig() {
        return this.keyOpenModConfig;
    }

    public KeyMapping keyReloadConfig() {
        return this.keyReloadConfig;
    }

    public KeyMapping keyToggleBlockShading() {
        return this.keyToggleBlockShading;
    }

    public KeyMapping keyToggleCloudShading() {
        return this.keyToggleCloudShading;
    }

    public KeyMapping keyToggleEntityShading() {
        return this.keyToggleEntityShading;
    }

    private void registerKeyMappings() {
        if (!this.fabricLoader.isModLoaded("fabric-key-binding-api-v1") || !this.fabricLoader.isModLoaded("fabric-lifecycle-events-v1")) {
            return;
        }
        KeyBindingHelper.registerKeyBinding((class_304)this.keyOpenModConfig());
        KeyBindingHelper.registerKeyBinding((class_304)this.keyReloadConfig());
        KeyBindingHelper.registerKeyBinding((class_304)this.keyToggleBlockShading());
        KeyBindingHelper.registerKeyBinding((class_304)this.keyToggleCloudShading());
        KeyBindingHelper.registerKeyBinding((class_304)this.keyToggleEntityShading());
        ClientTickEvents.END_CLIENT_TICK.register(this::consumeKeyEvents);
    }

    private static KeyMapping createKeyMapping(String name) {
        return new KeyMapping("simply-no-shading.key." + name, class_3675.field_16237.method_1444(), KEY_MAPPING_CATEGORY);
    }

    private void consumeKeyEvents(class_310 ignored) {
        if (this.keyOpenModConfig().method_1434()) {
            class_437 lastScreen = this.minecraft.field_1755;
            this.minecraft.method_1507(this.createConfigScreen(lastScreen));
        } else if (this.keyReloadConfig().method_1434()) {
            this.reloadConfig();
        } else {
            this.consumeKeyToggleEvents();
        }
    }

    public class_437 createConfigScreen(@Nullable class_437 lastScreen) {
        return new ConfigScreen(lastScreen, this.getConfig(), config -> {
            this.setConfigAndReload((Config)config);
            this.saveConfig();
        });
    }

    private void consumeKeyToggleEvents() {
        if (this.getContext().isShadersEnabled()) {
            this.keyToggleBlockShading().consumeAction();
            this.keyToggleCloudShading().consumeAction();
            this.keyToggleEntityShading().consumeAction();
            return;
        }
        boolean toggleBlockShading = this.keyToggleBlockShading.consumeReleased();
        boolean toggleCloudShading = this.keyToggleCloudShading.consumeReleased();
        boolean toggleEntityShading = this.keyToggleEntityShading.consumeReleased();
        if (toggleBlockShading || toggleCloudShading || toggleEntityShading) {
            Config config = this.getConfig();
            ConfigData data = config.data();
            this.setConfigAndReload(new Config(config.compatibilityMode(), ConfigPreset.CUSTOM, Optional.of(new ConfigData(data.shadeBlocks() ^ toggleBlockShading, data.shadeClouds() ^ toggleCloudShading, data.shadeEntities() ^ toggleEntityShading))));
        }
    }

    private void registerShutdownHook() {
        Thread shutdownThread = new Thread(this::saveConfig);
        shutdownThread.setName("Simply No Shading Shutdown Thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

