package io.github.startsmercury.simply_no_shading.impl.client.gui.screens;

import io.github.startsmercury.simply_no_shading.api.client.Config;
import io.github.startsmercury.simply_no_shading.api.client.SimplyNoShading;
import io.github.startsmercury.simply_no_shading.impl.client.ConfigImpl;
import io.github.startsmercury.simply_no_shading.impl.client.ShadingTarget;
import io.github.startsmercury.simply_no_shading.impl.client.SimplyNoShadingImpl;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

public final class ConfigScreen extends class_4667 {
    private static final class_2561 TITLE = class_2561.method_43471("simply-no-shading.config.title");
    private final ConfigImpl config;

    public ConfigScreen(final class_437 lastScreen, final Config config) {
        super(lastScreen, class_310.method_1551().field_1690, ConfigScreen.TITLE);

        Objects.requireNonNull(config, "Parameter config is null");

        this.config = new ConfigImpl(config);
    }

    @Override
    public void method_25432() {
        final var simplyNoShading = SimplyNoShading.instance();

        final var oldConfig = simplyNoShading.config();
        final var newConfig = this.config;
        simplyNoShading.setConfig(newConfig);
        ((SimplyNoShadingImpl) simplyNoShading).saveConfig();

        final var minecraft = super.field_22787;
        assert minecraft != null;
        SimplyNoShadingImpl.instance().applyChangesBetween(oldConfig, newConfig, minecraft);
    }

    @Override
    protected void method_60325() {
        final var list = this.field_51824;
        assert list != null;

        final var shadingOptions = ShadingTarget
            .valueList()
            .stream()
            .map(this::createShadingOption)
            .toArray(class_7172[]::new);
        list.method_20408(shadingOptions);
    }

    private class_7172<Boolean> createShadingOption(final ShadingTarget target) {
        final var key = "simply-no-shading.config.option." + target + "ShadingEnabled";
        final var tooltip = class_7919.method_47407(class_2561.method_43471(key + ".tooltip"));
        return class_7172.method_41750(
            key,
            enabled -> tooltip,
            target.getFrom(config),
            enabled -> target.setInto(config, enabled)
        );
    }
}
