/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.simply_no_shading.impl.client.config.v1;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.startsmercury.simply_no_shading.impl.client.config.v1.ConfigData;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public enum ConfigPreset {
    VANILLA(ConfigData.VANILLA),
    INTERNAL_SHADERS(ConfigData.INTERNAL_SHADERS),
    SIMPLY_NO_SHADING(ConfigData.DEFAULT),
    CUSTOM;

    private static final List<ConfigPreset> VALUE_LIST;
    public static final Codec<ConfigPreset> CODEC;
    private final Optional<ConfigData> override;

    public static List<ConfigPreset> valueList() {
        return VALUE_LIST;
    }

    private ConfigPreset() {
        this.override = Optional.empty();
    }

    private ConfigPreset(ConfigData override) {
        this.override = Optional.of(override);
    }

    public Optional<ConfigData> override() {
        return this.override;
    }

    static {
        VALUE_LIST = List.of(ConfigPreset.values());
        CODEC = Codec.STRING.comapFlatMap(input -> {
            try {
                return DataResult.success((Object)((Object)ConfigPreset.valueOf(input.toUpperCase(Locale.ROOT))));
            }
            catch (IllegalArgumentException cause) {
                return DataResult.error(() -> "Unrecognized configuration preset");
            }
        }, self -> self.name().toLowerCase(Locale.ROOT));
    }
}

