/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.network.ClientboundEnchantmentCluesMessage;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.QuickMoveRuleSet;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1718;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class ModEnchantmentMenu
extends class_1718
implements class_1712 {
    static final class_2960 EMPTY_SLOT_LAPIS_LAZULI = ResourceLocationHelper.withDefaultNamespace((String)"item/empty_slot_lapis_lazuli");
    static final class_2960 EMPTY_SLOT_AMETHYST_SHARD = class_2960.method_60656((String)"item/empty_slot_amethyst_shard");
    static final int REROLL_CATALYST_SLOT = 38;
    public static final int REROLL_DATA_SLOT = 4;
    public final class_1657 player;
    public final List<List<class_1889>> clues = Arrays.asList(List.of(), List.of(), List.of());

    public ModEnchantmentMenu(int id, class_1661 inventory) {
        this(id, inventory, (class_1263)new class_1277(3), class_3914.field_17304);
    }

    public ModEnchantmentMenu(int id, class_1661 inventory, class_1263 container, class_3914 access) {
        super(id, inventory, access);
        this.field_7809 = container;
        this.player = inventory.field_7546;
        class_1735 slot = this.method_7621(new class_1735(this, container, 2, 41, 47){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_31573(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_AMETHYST_SHARD);
            }

            public boolean method_7682() {
                return ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst();
            }
        });
        this.setSlot(0, new class_1735(this, container, 0, slot.method_7682() ? 5 : 15, 47){

            public int method_7675() {
                return 1;
            }
        });
        this.setSlot(1, new class_1735(this, container, 1, slot.method_7682() ? 23 : 35, 47){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_31573(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        this.method_7596(this);
    }

    public class_1735 setSlot(int index, class_1735 slot) {
        slot.field_7874 = index;
        this.field_7761.set(index, (Object)slot);
        return slot;
    }

    public class_3917<?> method_17358() {
        return (class_3917)ModRegistry.ENCHANTING_MENU_TYPE.comp_349();
    }

    public void method_7609(class_1263 container) {
        if (container == this.field_7809) {
            class_1799 itemStack = container.method_5438(0);
            if (!itemStack.method_7960() && itemStack.method_7923()) {
                this.field_7813.method_17393((level, pos) -> {
                    int enchantingPower = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((class_1937)level, (class_2338)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.field_7811.method_43052((long)this.field_7814.method_17407());
                    this.updateLevelsAndClues(level.method_30349(), itemStack, enchantingPower);
                    this.method_7623();
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    private int getEnchantingPower(class_1937 level, class_2338 blockPos) {
        float enchantingPower = 0.0f;
        int chiseledBookshelfBooks = 0;
        for (class_2338 offset : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)level, (class_2338)blockPos, (class_2338)offset)) continue;
            enchantingPower += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.method_8320(blockPos.method_10081((class_2382)offset)), level, blockPos.method_10081((class_2382)offset));
            chiseledBookshelfBooks += ChiseledBookshelfHelper.findValidBooks(level, blockPos, offset);
        }
        return (int)enchantingPower + chiseledBookshelfBooks / 3;
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.field_7808[i] = 0;
            this.field_7812[i] = -1;
            this.field_7810[i] = -1;
        }
    }

    private void updateLevelsAndClues(class_5455 registries, class_1799 itemStack, int enchantingPower) {
        for (int i = 0; i < 3; ++i) {
            List enchantmentList;
            this.field_7808[i] = class_1890.method_8227((class_5819)this.field_7811, (int)i, (int)enchantingPower, (class_1799)itemStack);
            if (this.field_7808[i] < i + 1) {
                this.field_7808[i] = 0;
            }
            if ((enchantmentList = this.method_7637(registries, itemStack, i, this.field_7808[i])).isEmpty()) {
                this.field_7808[i] = 0;
            }
            this.clues.set(i, this.createClue(enchantmentList));
        }
    }

    private List<class_1889> createClue(List<class_1889> enchantmentList) {
        return switch (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint) {
            default -> throw new MatchException(null, null);
            case ServerConfig.EnchantmentHint.NONE -> Collections.emptyList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                if (enchantmentList.isEmpty()) {
                    yield Collections.emptyList();
                }
                yield Collections.singletonList(enchantmentList.get(this.field_7811.method_43048(enchantmentList.size())));
            }
            case ServerConfig.EnchantmentHint.ALL -> ImmutableList.copyOf(enchantmentList);
        };
    }

    public void method_7623() {
        super.method_7623();
        EasyMagic.NETWORK.sendMessage(PlayerSet.ofEntity((class_1297)this.player), (ClientboundMessage)new ClientboundEnchantmentCluesMessage(this.field_7763, this.clues));
    }

    public void method_7635(class_1703 abstractContainerMenu, int i, class_1799 itemStack) {
        if (abstractContainerMenu == this) {
            this.field_7813.method_17393((Level, BlockPos) -> {
                if (i >= 0 && i < 2) {
                    this.method_7609(this.field_7809);
                }
            });
        }
    }

    public void method_7633(class_1703 abstractContainerMenu, int dataSlotIndex, int value) {
    }

    public boolean method_7604(class_1657 player, int data) {
        if (data == 4) {
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.canEnchantItem() && this.canUseReroll(player)) {
                this.field_7813.method_17393((level, pos) -> {
                    this.field_7814.method_17404(player.method_59922().method_43054());
                    player.field_7494 = this.field_7814.method_17407();
                    if (!player.method_31549().field_7477) {
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                            int catalystSlot = this.getRerollCatalystSlot();
                            class_1799 itemStack = this.field_7809.method_5438(catalystSlot);
                            itemStack.method_7934(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                            if (itemStack.method_7960()) {
                                this.field_7809.method_5447(catalystSlot, class_1799.field_8037);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels) {
                                player.method_7316(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                            } else {
                                player.method_7255(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                            }
                        }
                    }
                    this.field_7809.method_5431();
                    this.method_7609(this.field_7809);
                });
                return true;
            }
            return false;
        }
        return super.method_7604(player, data);
    }

    public boolean canEnchantItem() {
        return this.field_7809.method_5438(0).method_7923();
    }

    private int getRerollCatalystSlot() {
        return ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1;
    }

    public int getRerollCatalystCount() {
        return this.field_7809.method_5438(this.getRerollCatalystSlot()).method_7947();
    }

    public boolean canUseReroll(class_1657 player) {
        if (player.method_31549().field_7477) {
            return true;
        }
        int rerollExperiencePointsCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        return PlayerExperienceHelper.getTotalExperience(player) >= rerollExperiencePointsCost && this.getRerollCatalystCount() >= rerollCatalystCost;
    }

    public boolean method_7597(class_1657 player) {
        return this.field_7809.method_5443(player);
    }

    public void method_7595(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1799 itemStack = this.method_34255();
            if (!itemStack.method_7960()) {
                if (player.method_5805() && !serverPlayer.method_14239()) {
                    player.method_31548().method_7398(itemStack);
                } else {
                    player.method_7328(itemStack, false);
                }
                this.method_34254(class_1799.field_8037);
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return QuickMoveRuleSet.of((class_1703)this, (x$0, x$1, x$2, x$3) -> this.method_7616(x$0, x$1, x$2, x$3)).addContainerSlotRule(1).addContainerSlotRule(38, slot -> ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst()).addContainerSlotRule(0, slot -> this.isEnchantable(slot.method_7677())).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }

    private boolean isEnchantable(class_1799 itemStack) {
        if (!((class_9304)itemStack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385)).method_57543()) {
            return false;
        }
        return itemStack.method_7909().method_7870(itemStack) || itemStack.method_7909().method_7837() > 0;
    }
}

