/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.mojang.datafixers.util.Pair;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1718;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public class ModEnchantmentMenu
extends class_1718
implements class_1712 {
    static final class_2960 EMPTY_SLOT_LAPIS_LAZULI = ResourceLocationHelper.withDefaultNamespace((String)"item/empty_slot_lapis_lazuli");
    public static final int REROLL_CATALYST_SLOT = 38;
    private final class_1263 enchantSlots;
    private final class_3914 access;
    private final class_1657 player;
    private final class_5819 random;
    private final class_3915 enchantmentSeed;

    public ModEnchantmentMenu(int id, class_1661 playerInventory) {
        this(id, playerInventory, (class_1263)new class_1277(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 3 : 2), class_3914.field_17304);
    }

    public ModEnchantmentMenu(int id, class_1661 inventory, class_1263 container, class_3914 access) {
        super(id, inventory, access);
        this.enchantSlots = container;
        this.access = access;
        this.player = inventory.field_7546;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(container);
        boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
        if (dedicatedRerollCatalyst) {
            this.method_7621(new class_1735(this, container, 2, 41, 47){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_31573(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
                }
            });
        }
        this.setSlot(0, new class_1735(this, container, 0, dedicatedRerollCatalyst ? 5 : 15, 47){

            public int method_7675() {
                return 1;
            }
        });
        this.setSlot(1, new class_1735(this, container, 1, dedicatedRerollCatalyst ? 23 : 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        this.method_7596(this);
    }

    public class_1735 setSlot(int index, class_1735 slot) {
        slot.field_7874 = index;
        this.field_7761.set(index, (Object)slot);
        return slot;
    }

    public class_3917<?> method_17358() {
        return (class_3917)ModRegistry.ENCHANTMENT_MENU_TYPE.comp_349();
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.enchantSlots) {
            class_1799 itemStack = inventory.method_5438(0);
            if (!itemStack.method_7960() && itemStack.method_7923()) {
                this.access.method_17393((level, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((class_1937)level, (class_2338)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.random.method_43052((long)this.enchantmentSeed.method_17407());
                    this.updateLevels(itemStack, (class_1937)level, (class_2338)pos, power);
                    this.createClues(level.method_30349(), itemStack);
                    this.method_7623();
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void method_7635(class_1703 abstractContainerMenu, int i, class_1799 itemStack) {
        if (abstractContainerMenu == this) {
            this.access.method_17393((Level, BlockPos) -> {
                if (i >= 0 && i < 2) {
                    this.method_7609(this.enchantSlots);
                }
            });
        }
    }

    public void method_7633(class_1703 abstractContainerMenu, int dataSlotIndex, int value) {
        if (dataSlotIndex == 3) {
            this.random.method_43052((long)value);
        }
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.field_7808[i] = 0;
            this.field_7812[i] = -1;
            this.field_7810[i] = -1;
        }
    }

    private void updateLevels(class_1799 itemstack, class_1937 world, class_2338 pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.field_7808[i1] = class_1890.method_8227((class_5819)this.random, (int)i1, (int)power, (class_1799)itemstack);
            if (this.field_7808[i1] >= i1 + 1) continue;
            this.field_7808[i1] = 0;
        }
    }

    private void createClues(class_5455 registryAccess, class_1799 itemstack) {
        class_2359 idMap = registryAccess.method_30530(class_7924.field_41265).method_40295();
        for (int i = 0; i < 3; ++i) {
            List<class_1889> list;
            if (this.field_7808[i] <= 0 || (list = this.createEnchantmentInstance(registryAccess, itemstack, i)) == null || list.isEmpty()) continue;
            class_1889 enchantmentdata = list.get(this.random.method_43048(list.size()));
            this.field_7812[i] = idMap.method_10206((Object)enchantmentdata.field_9093);
            this.field_7810[i] = enchantmentdata.field_9094;
        }
    }

    public List<List<class_1889>> getEnchantingData(class_5455 registryAccess) {
        ServerConfig.EnchantmentHint enchantmentHint = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint;
        ArrayList<List<class_1889>> slotData = new ArrayList<List<class_1889>>(3);
        class_1799 itemStack = this.enchantSlots.method_5438(0);
        for (int i = 0; i < 3; ++i) {
            slotData.add(i, this.getEnchantmentHint(registryAccess, itemStack, i, enchantmentHint));
        }
        return slotData;
    }

    private List<class_1889> createEnchantmentInstance(class_5455 registryAccess, class_1799 itemStack, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(registryAccess, itemStack, enchantSlot, this.field_7808[enchantSlot]);
    }

    private List<class_1889> getEnchantmentHint(class_5455 registryAccess, class_1799 itemStack, int enchantSlot, ServerConfig.EnchantmentHint enchantmentHint) {
        return switch (enchantmentHint) {
            default -> throw new MatchException(null, null);
            case ServerConfig.EnchantmentHint.NONE -> Collections.emptyList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                List<class_1889> enchantmentData = this.createEnchantmentInstance(registryAccess, itemStack, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Collections.emptyList();
                }
                yield Collections.singletonList(enchantmentData.get(this.random.method_43048(enchantmentData.size())));
            }
            case ServerConfig.EnchantmentHint.ALL -> this.createEnchantmentInstance(registryAccess, itemStack, enchantSlot);
        };
    }

    private int getEnchantingPower(class_1937 level, class_2338 pos) {
        float enchantingPower = 0.0f;
        int chiseledBookshelfBooks = 0;
        for (class_2338 offset : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)level, (class_2338)pos, (class_2338)offset)) continue;
            enchantingPower += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.method_8320(pos.method_10081((class_2382)offset)), level, pos.method_10081((class_2382)offset));
            chiseledBookshelfBooks += ChiseledBookshelfHelper.findValidBooks(level, pos, offset);
        }
        return (int)enchantingPower + chiseledBookshelfBooks / 3;
    }

    public boolean method_7604(class_1657 player, int data) {
        if (data == 4) {
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.canUseReroll()) {
                int catalystSlot = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1;
                class_1799 itemstack = this.enchantSlots.method_5438(catalystSlot);
                if (player.method_31549().field_7477 || itemstack.method_7947() >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost) {
                    int totalExperience;
                    int n = totalExperience = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? player.field_7520 : PlayerExperienceHelper.getTotalExperience(player);
                    if (player.method_31549().field_7477 || totalExperience >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost) {
                        this.access.method_17393((level, pos) -> {
                            this.enchantmentSeed.method_17404(this.player.method_59922().method_43054());
                            ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.method_17407());
                            if (!player.method_31549().field_7477) {
                                if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                                    itemstack.method_7934(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                                    if (itemstack.method_7960()) {
                                        this.enchantSlots.method_5447(catalystSlot, class_1799.field_8037);
                                    }
                                }
                                if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                                    if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels) {
                                        player.method_7316(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                                    } else {
                                        player.method_7255(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                                    }
                                }
                            }
                            this.enchantSlots.method_5431();
                            this.method_7609(this.enchantSlots);
                        });
                        return true;
                    }
                }
            }
            return false;
        }
        return super.method_7604(player, data);
    }

    public boolean canUseReroll() {
        class_1799 itemToEnchant = this.enchantSlots.method_5438(0);
        if (!itemToEnchant.method_7960() && itemToEnchant.method_7923()) {
            for (int cost : this.field_7808) {
                if (cost <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean method_7597(class_1657 player) {
        return this.enchantSlots.method_5443(player);
    }

    public void method_7595(class_1657 player) {
        class_1799 itemstack;
        if (player instanceof class_3222 && !(itemstack = this.method_34255()).method_7960()) {
            if (player.method_5805() && !((class_3222)player).method_14239()) {
                player.method_31548().method_7398(itemstack);
            } else {
                player.method_7328(itemstack, false);
            }
            this.method_34254(class_1799.field_8037);
        }
    }

    public int getRerollCatalystCount() {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            return this.enchantSlots.method_5438(2).method_7947();
        }
        return this.method_7638();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            boolean override = false;
            boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
            if (dedicatedRerollCatalyst && index == 38) {
                override = true;
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (index != 0 && index != 1) {
                if (itemStack2.method_31573(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.method_7616(itemStack2, 1, 2, true)) {
                        return class_1799.field_8037;
                    }
                } else if (dedicatedRerollCatalyst && itemStack2.method_31573(ModRegistry.REROLL_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.method_7616(itemStack2, 38, 39, true)) {
                        return class_1799.field_8037;
                    }
                }
            }
            if (!override) {
                return super.method_7601(player, index);
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }
}

