/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import me.andreasmelone.glowingeyes.GlowingEyes;
import me.andreasmelone.glowingeyes.client.commands.AbstractClientCommand;
import me.andreasmelone.glowingeyes.client.compat.CompatPlugin;
import me.andreasmelone.glowingeyes.client.compat.CompatPluginRegistry;
import me.andreasmelone.glowingeyes.client.gui.EyesEditorScreen;
import me.andreasmelone.glowingeyes.client.gui.skin.ISkinPart;
import me.andreasmelone.glowingeyes.client.mod.ClientModContext;
import me.andreasmelone.glowingeyes.client.presets.PresetManager;
import me.andreasmelone.glowingeyes.client.util.IrisUtils;
import me.andreasmelone.glowingeyes.client.util.OptifineUtils;
import me.andreasmelone.glowingeyes.client.util.SkinUtil;
import me.andreasmelone.glowingeyes.client.util.color.ColorType;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.LoaderUtils;
import me.andreasmelone.glowingeyes.common.util.Point;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.entity.player.Player;

public class EyesCommand<T extends SharedSuggestionProvider>
extends AbstractClientCommand<T> {
    public EyesCommand(Function<String, LiteralArgumentBuilder<T>> stringLiteralArgumentBuilderFunction) {
        super(stringLiteralArgumentBuilderFunction);
    }

    @Override
    public void register(ClientModContext mod, CommandDispatcher<T> dispatcher) {
        LiteralArgumentBuilder command = this.literal("eyes");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.executes(ctx -> this.open(mod))).then(this.literal("open").executes(ctx -> this.open(mod)))).then(this.literal("dump").executes(ctx -> this.dump(mod)))).then(this.literal("debuginfo").executes(ctx -> this.debugInfo(mod)));
        dispatcher.register(command);
    }

    private int open(ClientModContext mod) {
        Minecraft mc = Minecraft.getInstance();
        GlowingEyes.SCHEDULER_CLIENT.runLater(() -> mc.setScreen((Screen)new EyesEditorScreen(mod)), 1L);
        return 1;
    }

    private int dump(ClientModContext mod) {
        Minecraft mc = Minecraft.getInstance();
        Map<Point, Color> map = GlowingEyesComponent.getGlowingEyesMap((Player)mc.player);
        Color selectedColor = mod.getModVariables().getFinalColor();
        float brightness = mod.getModVariables().getBrightness();
        Color finalColor = mod.getModVariables().getFinalColor();
        boolean toggledOn = GlowingEyesComponent.isToggledOn((Player)mc.player);
        File dumpFile = new File("glowingeyes-dump-" + System.currentTimeMillis() + ".json");
        try (FileOutputStream out = new FileOutputStream(dumpFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject obj = new JsonObject();
            obj.addProperty("mod_version", LoaderUtils.MOD_VERSION);
            obj.addProperty("loader", LoaderUtils.LOADER_NAME);
            obj.addProperty("minecraft_version", SharedConstants.getCurrentVersion().name());
            obj.addProperty("optifine_present", Boolean.valueOf(OptifineUtils.IS_OPTIFINE_PRESENT));
            obj.addProperty("iris_present", Boolean.valueOf(IrisUtils.IS_IRIS_PRESENT));
            obj.addProperty("cpu", GLX._getCpuInfo());
            obj.addProperty("gpu", RenderSystem.getDevice().getRenderer());
            JsonArray mods = new JsonArray();
            for (int i = 0; i < LoaderUtils.LOADED_MODS.length; ++i) {
                LoaderUtils.ModData data = LoaderUtils.LOADED_MODS[i];
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("name", data.name());
                jsonObject.addProperty("id", data.id());
                jsonObject.addProperty("version", data.version());
                mods.add((JsonElement)jsonObject);
            }
            obj.add("loaded_mods", (JsonElement)mods);
            obj.add("selected_color", (JsonElement)EyesCommand.colorToJson(selectedColor));
            obj.addProperty("brightness", (Number)Float.valueOf(brightness));
            obj.add("finalColor", (JsonElement)EyesCommand.colorToJson(finalColor));
            obj.addProperty("toggled_on", Boolean.valueOf(toggledOn));
            if (OptifineUtils.IS_OPTIFINE_PRESENT) {
                obj.addProperty("optifine_shader", OptifineUtils.getShaderName());
            }
            if (IrisUtils.IS_IRIS_PRESENT) {
                obj.addProperty("iris_shader", IrisUtils.getShaderName());
            }
            JsonArray compatPlugins = new JsonArray();
            for (CompatPlugin compatPlugin : CompatPluginRegistry.getCompatPlugins()) {
                CompatPlugin.Info info = compatPlugin.getPluginInfo();
                JsonObject compatPluginObj = new JsonObject();
                compatPluginObj.addProperty("id", info.id().toString());
                compatPluginObj.addProperty("name", info.name());
                compatPluginObj.addProperty("version", info.version());
                compatPlugins.add((JsonElement)compatPluginObj);
            }
            obj.add("compat_plugins", (JsonElement)compatPlugins);
            JsonArray resourcePacks = new JsonArray();
            for (Pack pack : mc.getResourcePackRepository().getSelectedPacks()) {
                JsonObject resourcePack = new JsonObject();
                resourcePack.addProperty("title", pack.getTitle().getString());
                resourcePack.addProperty("description", pack.getDescription().getString());
            }
            obj.add("resourcepacks", (JsonElement)resourcePacks);
            JsonObject jsonObject = new JsonObject();
            JsonObject currentPartObj = new JsonObject();
            Object currentPart = null;
            for (Map.Entry<Point, Color> entry : map.entrySet()) {
                Point point = entry.getKey();
                Color color = entry.getValue();
                ISkinPart newPart = ISkinPart.getFromCoordinates(point.getX(), point.getY(), SkinUtil.isSlim());
                if (currentPart != newPart) {
                    if (currentPart != null) {
                        jsonObject.add(currentPart.toString(), (JsonElement)currentPartObj);
                    }
                    currentPartObj = new JsonObject();
                }
                currentPartObj.add("x: " + point.getX() + ", y: " + point.getY(), (JsonElement)EyesCommand.colorToJson(color));
                currentPart = newPart;
            }
            if (currentPart != null) {
                jsonObject.add(currentPart.toString(), (JsonElement)currentPartObj);
            }
            obj.add("glowing_map", (JsonElement)jsonObject);
            obj.addProperty("presets_version", (Number)4);
            obj.add("presets", PresetManager.getInstance().serializePresets());
            ((OutputStream)out).write(gson.toJson((JsonElement)obj).getBytes(StandardCharsets.UTF_8));
            MutableComponent clickableComponent = Component.literal((String)dumpFile.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(dumpFile.getAbsolutePath())));
            mc.player.displayClientMessage((Component)Component.literal((String)"Successfully dumped eyes to ").append((Component)clickableComponent), false);
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Unable to dump", (Throwable)e);
            mc.player.displayClientMessage((Component)Component.literal((String)"Failed to dump! Try again or report to the mod author.").withStyle(ChatFormatting.RED), false);
        }
        return 1;
    }

    private int debugInfo(ClientModContext mod) {
        LocalPlayer player = Minecraft.getInstance().player;
        Color selectedColor = mod.getModVariables().getFinalColor();
        float brightness = mod.getModVariables().getBrightness();
        Color finalColor = mod.getModVariables().getFinalColor();
        boolean toggledOn = GlowingEyesComponent.isToggledOn((Player)player);
        player.displayClientMessage((Component)Component.literal((String)"Selected color: ").append((Component)Component.literal((String)ColorType.HEX.get(selectedColor))).withStyle(Style.EMPTY.withColor(selectedColor.getRGB())), false);
        player.displayClientMessage((Component)Component.literal((String)"Brightness: ").append(String.format("%.2f", Float.valueOf(brightness))), false);
        player.displayClientMessage((Component)Component.literal((String)"Final color: ").append((Component)Component.literal((String)ColorType.HEX.get(finalColor))).withStyle(Style.EMPTY.withColor(finalColor.getRGB())), false);
        player.displayClientMessage((Component)Component.literal((String)"Toggled ").append(toggledOn ? "ON" : "OFF"), false);
        player.displayClientMessage((Component)Component.literal((String)"Layout: ").append(GlowingEyesComponent.getGlowingEyesMap((Player)player).toString()), false);
        return 1;
    }

    private static JsonObject colorToJson(Color color) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("r", (Number)color.getRed());
        jsonObject.addProperty("g", (Number)color.getGreen());
        jsonObject.addProperty("b", (Number)color.getBlue());
        return jsonObject;
    }
}

