/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.compat;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.andreasmelone.glowingeyes.client.compat.CompatPlugin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class CompatPluginRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, CompatPlugin> PLUGINS = new HashMap<ResourceLocation, CompatPlugin>();

    public static void register(CompatPlugin plugin, boolean load) {
        if (PLUGINS.containsKey(plugin.getPluginInfo().id())) {
            throw new IllegalArgumentException("Plugin with ID " + String.valueOf(plugin.getPluginInfo().id()) + " already registered: " + String.valueOf(plugin.getPluginInfo()));
        }
        LOGGER.info("Registering compat plugin {} {}", (Object)plugin.getPluginInfo().name(), (Object)plugin.getPluginInfo().version());
        PLUGINS.put(plugin.getPluginInfo().id(), plugin);
        plugin.onRegister();
        if (load) {
            CompatPluginRegistry.loadPlugin(plugin.getPluginInfo().id());
        }
    }

    public static void loadPlugin(ResourceLocation id) {
        CompatPlugin plugin = CompatPluginRegistry.getById(id);
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin " + String.valueOf(id) + " not found");
        }
        if (plugin.isLoaded()) {
            return;
        }
        LOGGER.info("Loading compat plugin {} {}", (Object)plugin.getPluginInfo().name(), (Object)plugin.getPluginInfo().version());
        plugin.onLoad();
    }

    public static void unloadPlugin(ResourceLocation id) {
        CompatPlugin plugin = CompatPluginRegistry.getById(id);
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin " + String.valueOf(id) + " not found");
        }
        if (!plugin.isLoaded()) {
            return;
        }
        LOGGER.info("Unloading compat plugin {} {}", (Object)plugin.getPluginInfo().name(), (Object)plugin.getPluginInfo().version());
        plugin.onUnload();
    }

    public static CompatPlugin getById(ResourceLocation id) {
        return PLUGINS.get(id);
    }

    @ApiStatus.Internal
    public static <T extends CustomPacketPayload> void raisePacketSendToServerEvent(T packet) {
        PLUGINS.forEach((id, plugin) -> {
            if (!plugin.isLoaded()) {
                return;
            }
            plugin.onPacketSendToServer(packet);
        });
    }

    public static Set<CompatPlugin> getCompatPlugins() {
        return new HashSet<CompatPlugin>(PLUGINS.values());
    }
}

