/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.andreasmelone.glowingeyes.client.gui.widget.ColorPickerWidget;
import me.andreasmelone.glowingeyes.client.gui.widget.ColorSliderWidget;
import me.andreasmelone.glowingeyes.client.mod.ClientModContext;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.client.util.color.ColorType;
import me.andreasmelone.glowingeyes.client.util.color.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorPickerScreen
extends Screen {
    private static final int UI_WIDTH = 256;
    private static final int UI_HEIGHT = 222;
    private static final int EDIT_BOX_X = 186;
    private static final int EDIT_BOX_Y = 20;
    private static final int EDIT_BOX_SPACING = 30;
    private static final int COLOR_WHEEL_WIDTH = 100;
    private static final int COLOR_WHEEL_X = 20;
    private static final int BRIGHTNESS_SLIDER_X = 120;
    private static final int BRIGHTNESS_SLIDER_WIDTH = 25;
    private static final int COLOR_WIDGET_HEIGHT = 100;
    private static final int SELECTED_COLOR_X = 216;
    private static final int SELECTED_COLOR_Y = 182;
    private static final int SELECTED_COLOR_WIDTH = 25;
    private static final int SELECTED_COLOR_HEIGHT = 25;
    private static final int EDIT_BOX_WIDTH = 60;
    private static final int EDIT_BOX_HEIGHT = 20;
    private int guiLeft;
    private int guiTop;
    private int colorWheelX;
    private int colorWheelY;
    private int brightnessSliderX;
    private int brightnessSliderY;
    private ColorPickerWidget colorPickerWidget;
    private ColorSliderWidget colorSliderWidget;
    private final Screen parent;
    private final ClientModContext mod;
    private final Map<ColorType, EditBox> editBoxMap = new EnumMap<ColorType, EditBox>(ColorType.class);

    public ColorPickerScreen(ClientModContext mod) {
        super((Component)Component.empty());
        this.parent = null;
        this.mod = mod;
    }

    public ColorPickerScreen(ClientModContext mod, Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        this.mod = mod;
    }

    protected void init() {
        super.init();
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.parent.clearFocus();
        }
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 222) / 2;
        this.colorWheelX = this.guiLeft + 20;
        this.colorWheelY = this.height / 2 - 50;
        this.brightnessSliderX = this.colorWheelX + 120;
        this.brightnessSliderY = this.colorWheelY;
        this.editBoxMap.clear();
        this.editBoxMap.put(ColorType.RED, this.createEditBox(this.guiLeft + 186, this.guiTop + 20, (Component)Component.empty()));
        this.editBoxMap.put(ColorType.GREEN, this.createEditBox(this.guiLeft + 186, this.guiTop + 20 + 30 * this.editBoxMap.size(), (Component)Component.empty()));
        this.editBoxMap.put(ColorType.BLUE, this.createEditBox(this.guiLeft + 186, this.guiTop + 20 + 30 * this.editBoxMap.size(), (Component)Component.empty()));
        this.editBoxMap.put(ColorType.HEX, this.createEditBox(this.guiLeft + 186, this.guiTop + 20 + 30 * this.editBoxMap.size(), (Component)Component.empty()));
        this.editBoxMap.forEach((type, field) -> {
            field.setResponder(string -> {
                if (!field.isFocused() || string.isEmpty()) {
                    return;
                }
                this.editBoxMap.forEach((t, f) -> {
                    if (t != type) {
                        f.setFocused(false);
                    }
                });
                float[] hsb = ColorUtil.getHSBFromRGB(type.parseAndUpdate(this.mod.getModVariables().getFinalColor(), (String)string).getRGB());
                this.changeColor(hsb[0], hsb[1], hsb[2], t -> t == type);
            });
            this.addRenderableWidget((GuiEventListener)field);
        });
        this.colorPickerWidget = this.createOrUpdateWidget(this.colorPickerWidget, this.colorWheelX, this.colorWheelY, () -> {
            ColorPickerWidget widget = new ColorPickerWidget(this.colorWheelX, this.colorWheelY, 100, 100, this.mod.getModVariables().getHue(), this.mod.getModVariables().getBrightness(), this.mod.getModVariables().getSaturation());
            widget.onChange(picker -> this.changeColor(this.mod.getModVariables().getHue(), picker.getSaturation(), picker.getBrightness()));
            return widget;
        });
        this.colorSliderWidget = this.createOrUpdateWidget(this.colorSliderWidget, this.brightnessSliderX, this.brightnessSliderY, () -> {
            ColorSliderWidget widget = new ColorSliderWidget(this.brightnessSliderX, this.brightnessSliderY, 25, 100, this.mod.getModVariables().getHue());
            widget.onChange(slider -> this.changeColor(slider.getHue(), this.mod.getModVariables().getSaturation(), this.mod.getModVariables().getBrightness()));
            return widget;
        });
        this.addRenderableWidget(this.colorPickerWidget);
        this.addRenderableWidget(this.colorSliderWidget);
        this.changeColor(this.mod.getModVariables().getHue(), this.mod.getModVariables().getSaturation(), this.mod.getModVariables().getBrightness());
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        if (this.parent != null) {
            this.parent.render(ctx, 0, 0, delta);
            GuiUtil.drawTransparentBlack(ctx);
        } else {
            super.renderBackground(ctx, mouseX, mouseY, delta);
        }
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_BROAD, this.guiLeft, this.guiTop, 256, 222);
        ctx.fill(this.guiLeft + 216, this.guiTop + 182, this.guiLeft + 216 + 25, this.guiTop + 182 + 25, this.mod.getModVariables().getFinalColor().getRGB());
        super.render(ctx, mouseX, mouseY, delta);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTick) {
    }

    private void changeColor(float hue, float saturation, float brightness) {
        this.changeColor(hue, saturation, brightness, type -> false);
    }

    private void changeColor(float hue, float saturation, float brightness, Predicate<ColorType> predicate) {
        this.mod.getModVariables().setHue(hue);
        this.mod.getModVariables().setSaturation(saturation);
        this.mod.getModVariables().setBrightness(brightness);
        this.colorPickerWidget.setHue(hue);
        this.colorPickerWidget.setSaturation(saturation);
        this.colorPickerWidget.setBrightness(brightness);
        this.colorSliderWidget.setHue(hue);
        this.editBoxMap.forEach((type, box) -> {
            if (predicate.test((ColorType)((Object)type))) {
                return;
            }
            box.setValue(type.get(this.mod.getModVariables().getFinalColor()));
        });
    }

    private EditBox createEditBox(int x, int y, Component component) {
        return new EditBox(this.font, x, y, 60, 20, component);
    }

    private <T extends AbstractWidget> T createOrUpdateWidget(T widget, int x, int y, Supplier<T> widgetFactory) {
        if (widget == null) {
            widget = (AbstractWidget)widgetFactory.get();
        } else {
            widget.setX(x);
            widget.setY(y);
        }
        return widget;
    }
}

