/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui;

import java.util.HashMap;
import me.andreasmelone.glowingeyes.client.component.eyes.ClientGlowingEyesComponent;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.Point;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ConfirmResetScreen
extends Screen {
    private static final int UI_WIDTH = 200;
    private static final int UI_HEIGHT = 118;
    private static final int BUTTON_Y = 93;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_OFFSET_MIDDLE_X = 2;
    private static final int TEXT_PADDING = 14;
    private static final int TITLE_Y = -20;
    private static final int WARNING_Y = 5;
    private int guiLeft;
    private int guiTop;
    private int middleX;
    private int middleY;
    private final Screen parent;

    protected ConfirmResetScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
    }

    protected void init() {
        super.init();
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.parent.clearFocus();
        }
        this.guiLeft = (this.width - 200) / 2;
        this.guiTop = (this.height - 118) / 2;
        this.middleX = this.guiLeft + 100;
        this.middleY = this.guiTop + 59;
        int width = this.middleX - this.guiLeft - 7;
        int confirmX = this.middleX - width - 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.confirm"), button -> {
            if (this.parent != null) {
                GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, new HashMap<Point, Color>());
                ClientGlowingEyesComponent.sendUpdate();
                Minecraft.getInstance().setScreen(this.parent);
            }
        }).pos(confirmX, this.guiTop + 93).size(width, 20).build());
        int cancelX = this.middleX + 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.cancel"), button -> {
            if (this.parent != null) {
                Minecraft.getInstance().setScreen(this.parent);
            }
        }).pos(cancelX, this.guiTop + 93).size(width, 20).build());
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.render(ctx, 0, 0, partialTicks);
            GuiUtil.drawTransparentBlack(ctx);
        } else {
            super.renderBackground(ctx, mouseX, mouseY, partialTicks);
        }
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_SLIM, this.guiLeft, this.guiTop, 200, 118);
        ctx.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"gui.glowingeyes.warning").withStyle(ChatFormatting.BOLD), this.middleX, this.guiTop + 7, Color.RED.getRGB());
        GuiUtil.drawWrappedText(ctx, this.minecraft.font, (Component)Component.translatable((String)"gui.glowingeyes.reset.title"), this.guiLeft + 100, this.middleY + -20, 186, Color.WHITE.getRGB());
        GuiUtil.drawWrappedText(ctx, this.minecraft.font, (Component)Component.translatable((String)"gui.glowingeyes.reset.warning"), this.guiLeft + 100, this.middleY + 5, 186, Color.RED.getRGB());
        super.render(ctx, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
    }
}

