/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import me.andreasmelone.glowingeyes.client.component.eyes.ClientGlowingEyesComponent;
import me.andreasmelone.glowingeyes.client.gui.ColorPickerScreen;
import me.andreasmelone.glowingeyes.client.gui.ConfirmResetScreen;
import me.andreasmelone.glowingeyes.client.gui.button.TintedOverlayImageButton;
import me.andreasmelone.glowingeyes.client.gui.preset.PresetsScreen;
import me.andreasmelone.glowingeyes.client.gui.skin.ClassicSkinPart;
import me.andreasmelone.glowingeyes.client.gui.skin.ISkinPart;
import me.andreasmelone.glowingeyes.client.gui.skin.SkinPartSelectorScreen;
import me.andreasmelone.glowingeyes.client.gui.widget.CursorSpaceWidget;
import me.andreasmelone.glowingeyes.client.mod.ClientModContext;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.SkinUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.client.util.color.ColorType;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.Point;
import me.andreasmelone.glowingeyes.mixin.client.GpuTextureAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class EyesEditorScreen
extends Screen {
    private static final int UI_WIDTH = 256;
    private static final int UI_HEIGHT = 222;
    private static final int CLICK_DELAY = 200;
    private static final int MODE_BUTTON_WIDTH = 20;
    private static final int MODE_BUTTON_HEIGHT = 20;
    private static final int MODE_BUTTON_SPACING = 5;
    private static final int MODE_BUTTON_X = 8;
    private static final int BUTTON_WIDTH = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACE_BETWEEN_PIXELS = 2;
    private static final int PIXEL_SIZE = 16;
    private static final Color HEAD_BACKGROUND_COLOR = new Color(160, 160, 160, 255);
    private static final Color GRID_LINES_COLOR = new Color(120, 120, 120, 255);
    private static final int MENU_BUTTONS_X = 226;
    private static final int MENU_BUTTONS_SPACING = 5;
    private static final int COLOR_BOX_WIDTH = 20;
    private static final int COLOR_BOX_HEIGHT = 20;
    private static final int COLOR_BOX_OFFSET_Y = -25;
    private static final int COLOR_LABEL_OFFSET_Y = 10;
    private static final int COLOR_BOX_BG_MARGIN_X = 3;
    private static final int COLOR_BOX_BG_MARGIN_Y = 10;
    private int guiLeft;
    private int guiTop;
    private int headX;
    private int headY;
    private int endHeadX;
    private int endHeadY;
    private int headSizeX;
    private int headSizeY;
    private float scale = 1.0f;
    private long openedAt;
    protected Mode mode = Mode.values()[0];
    protected ISkinPart skinPart = ISkinPart.getPart(ClassicSkinPart.HEAD_FRONT, SkinUtil.isSlim());
    protected Map<Point, Color> pixels = new HashMap<Point, Color>();
    private CursorSpaceWidget cursorSpaceWidget;
    private final Map<Mode, Button> modeButtons = new EnumMap<Mode, Button>(Mode.class);
    private final Map<ResourceLocation, NativeImage> allocatedTextures = new HashMap<ResourceLocation, NativeImage>();
    private final ClientModContext mod;

    public EyesEditorScreen(ClientModContext mod) {
        super((Component)Component.empty());
        this.mod = mod;
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 222) / 2;
        this.headSizeX = this.skinPart.getSizeX();
        this.headSizeY = this.skinPart.getSizeY();
        this.openedAt = System.currentTimeMillis();
        this.calculateHeadSize();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.pixels = GlowingEyesComponent.getGlowingEyesMap((Player)player);
        } else {
            LogUtils.getLogger().error("Could not load glowing eyes map from player capability");
        }
        this.modeButtons.clear();
        float middleY = (float)this.height / 2.0f;
        int modeCount = Mode.values().length;
        float totalHeight = modeCount * 20 + (modeCount - 1) * 5;
        float startY = middleY - totalHeight / 2.0f;
        for (int i = 0; i < modeCount; ++i) {
            int posY = (int)(startY + (float)(i * 25));
            this.addRenderableWidget((GuiEventListener)this.createModeButton(this.guiLeft + 8, posY, Mode.values()[i]));
        }
        Button brushButton = this.modeButtons.get((Object)Mode.BRUSH);
        brushButton.onClick(new MouseButtonEvent((double)(brushButton.getX() + 1), (double)(brushButton.getY() + 1), new MouseButtonInfo(0, 0)), false);
        this.cursorSpaceWidget = new CursorSpaceWidget(this.headX, this.headY, this.endHeadX - this.headX, this.endHeadY - this.headY, (arg_0, arg_1) -> ((EyesEditorScreen)this).mouseMoved(arg_0, arg_1), this::mouseClicked);
        this.addRenderableWidget(this.cursorSpaceWidget);
        ArrayList<ImageButton> menuButtons = new ArrayList<ImageButton>();
        ImageButton resetButton = new ImageButton(this.guiLeft + 226, 0, 20, 20, TextureLocations.RESET_BUTTON, button -> this.minecraft.setScreen((Screen)new ConfirmResetScreen(this)));
        menuButtons.add(resetButton);
        this.addRenderableWidget((GuiEventListener)resetButton);
        resetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.glowingeyes.editor.reset")));
        ImageButton skinPartPicker = new ImageButton(this.guiLeft + 226, 0, 20, 20, TextureLocations.SKIN_PART_PICKER_BUTTON, button -> SkinPartSelectorScreen.create(this, this.minecraft.player.getSkin().body().texturePath(), this.skinPart).thenAccept(part -> {
            if (part != null) {
                this.skinPart = part;
                this.headSizeX = this.skinPart.getSizeX();
                this.headSizeY = this.skinPart.getSizeY();
                this.calculateHeadSize();
            }
        }));
        menuButtons.add(skinPartPicker);
        this.addRenderableWidget((GuiEventListener)skinPartPicker);
        skinPartPicker.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.glowingeyes.editor.partpicker")));
        ImageButton presetMenuButton = new ImageButton(this.guiLeft + 226, 0, 20, 20, TextureLocations.PRESET_MENU_BUTTON, button -> Minecraft.getInstance().setScreen((Screen)new PresetsScreen(this)));
        menuButtons.add(presetMenuButton);
        this.addRenderableWidget((GuiEventListener)presetMenuButton);
        presetMenuButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.glowingeyes.editor.presetsmenu")));
        ImageButton colorPickerButton = new ImageButton(this.guiLeft + 226, 0, 20, 20, TextureLocations.COLOR_PICKER_BUTTON, button -> Minecraft.getInstance().setScreen((Screen)new ColorPickerScreen(this.mod, this)));
        menuButtons.add(colorPickerButton);
        this.addRenderableWidget((GuiEventListener)colorPickerButton);
        colorPickerButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.glowingeyes.editor.colorpicker")));
        int count = menuButtons.size();
        totalHeight = count * 20 + (count - 1) * 5;
        startY = middleY - totalHeight / 2.0f;
        for (int i = 0; i < count; ++i) {
            int posY = (int)(startY + (float)(i * 25));
            ((Button)menuButtons.get(i)).setY(posY);
        }
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float deltaTime) {
        super.renderBackground(ctx, mouseX, mouseY, deltaTime);
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_BROAD, this.guiLeft, this.guiTop, 256, 222);
        ctx.pose().pushMatrix();
        ctx.pose().translate(((float)this.width - (float)this.width * this.scale) / 2.0f, ((float)this.height - (float)this.height * this.scale) / 2.0f);
        ctx.pose().scale(this.scale, this.scale);
        ctx.fill(this.headX - 2, this.headY - 2, this.endHeadX + 2, this.endHeadY + 2, HEAD_BACKGROUND_COLOR.getRGB());
        for (int y = 0; y < this.headSizeY + 1; ++y) {
            ctx.fill(this.headX - 2, this.headY + 16 * y + 2 * (y - 1), this.endHeadX + 2, this.headY + 16 * y + 2 * (y - 1) + 2, GRID_LINES_COLOR.getRGB());
        }
        for (int x = 0; x < this.headSizeX + 1; ++x) {
            ctx.fill(this.headX + 16 * x + 2 * (x - 1), this.headY - 2, this.headX + 16 * x + 2 * (x - 1) + 2, this.endHeadY + 2, GRID_LINES_COLOR.getRGB());
        }
        ResourceLocation playerSkin = Minecraft.getInstance().player.getSkin().body().texturePath();
        for (int y = 0; y < this.headSizeY; ++y) {
            for (int x = 0; x < this.headSizeX; ++x) {
                Point point = new Point(x + this.skinPart.getX(), y + this.skinPart.getY());
                ctx.blit(RenderPipelines.GUI_TEXTURED, playerSkin, this.headX + x * 16 + x * 2, this.headY + y * 16 + y * 2, (float)(this.skinPart.getX() + x), (float)(this.skinPart.getY() + y), 16, 16, 1, 1, 64, 64);
                if (!this.pixels.containsKey(point)) continue;
                ctx.fill(this.headX + x * 16 + x * 2 - 1, this.headY + y * 16 + y * 2 - 1, this.headX + x * 16 + x * 2 + 16 + 1, this.headY + y * 16 + y * 2 + 16 + 1, this.pixels.get(point).getRGB());
            }
        }
        ctx.pose().popMatrix();
        if (this.mode == Mode.PICKER && this.checkBounds(mouseX, mouseY, this.headX, this.endHeadX, this.headY, this.endHeadY)) {
            Point convertedMouse = this.calculatePoint(mouseX, mouseY);
            Color color = this.getTexturePixelColor(playerSkin, 64, 64, convertedMouse.getX(), convertedMouse.getY());
            String text = ColorType.HEX.get(color);
            int length = this.font.width(text);
            ctx.fill(mouseX - length / 2 - 3, mouseY - 10 + 10, mouseX + length / 2 + 3, mouseY - 10 + -25 - 10, -1442840576);
            ctx.fill(mouseX - 10, mouseY - 10 + -25, mouseX + 10, mouseY + 10 + -25, color.getRGB());
            ctx.drawCenteredString(this.minecraft.font, text, mouseX, mouseY - 10, Color.WHITE.getRGB());
        }
        super.render(ctx, mouseX, mouseY, deltaTime);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        double mouseX = event.x();
        double mouseY = event.y();
        if (System.currentTimeMillis() < this.openedAt + 200L) {
            return false;
        }
        if (this.checkBounds((float)mouseX, (float)mouseY, this.headX, this.endHeadX, this.headY, this.endHeadY)) {
            this.mode.onButtonPress(this, mouseX, mouseY, event.button());
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        return this.mouseClicked(event, false);
    }

    public void onClose() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            GlowingEyesComponent.setGlowingEyesMap((Player)player, this.pixels);
            ClientGlowingEyesComponent.sendUpdate();
        } else {
            LogUtils.getLogger().error("Could not save glowing eyes map to player capability");
        }
        this.allocatedTextures.forEach((rl, nativeImage) -> nativeImage.close());
        this.allocatedTextures.clear();
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTick) {
    }

    private Color getTexturePixelColor(ResourceLocation texture, int texSizeX, int texSizeY, int x, int y) {
        if (x < 0 || x >= texSizeX) {
            throw new IllegalArgumentException("x must be within the screen width: 0 to " + (texSizeX - 1) + ". Provided: " + x);
        }
        if (y < 0 || y >= texSizeY) {
            throw new IllegalArgumentException("y must be within the screen height: 0 to " + (texSizeY - 1) + ". Provided: " + y);
        }
        Point point = new Point(x, y);
        if (this.pixels.containsKey(point)) {
            Color color = this.pixels.get(point);
            return color.withAlpha(255);
        }
        if (!this.allocatedTextures.containsKey(texture)) {
            long startTime = System.currentTimeMillis();
            GpuTexture gpuTexture = this.minecraft.getTextureManager().getTexture(texture).getTexture();
            int initialUsage = gpuTexture.usage();
            ((GpuTextureAccessor)gpuTexture).setUsage(initialUsage | 2);
            GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Skin copy buffer", 9, texSizeX * texSizeY * gpuTexture.getFormat().pixelSize());
            CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
            NativeImage nativeImage = new NativeImage(texSizeX, texSizeY, false);
            commandEncoder.copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
                try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                    for (int ty = 0; ty < texSizeY; ++ty) {
                        for (int tx = 0; tx < texSizeX; ++tx) {
                            int m = mappedView.data().getInt((tx + ty * texSizeX) * gpuTexture.getFormat().pixelSize());
                            nativeImage.setPixelABGR(tx, ty, m);
                        }
                    }
                }
                gpuBuffer.close();
            }, 0);
            ((GpuTextureAccessor)gpuTexture).setUsage(initialUsage);
            LogUtils.getLogger().debug("Reading texture {} took {}ms", (Object)texture, (Object)(System.currentTimeMillis() - startTime));
            this.allocatedTextures.put(texture, nativeImage);
            return new Color(nativeImage.getPixel(x, y));
        }
        NativeImage img = this.allocatedTextures.get(texture);
        return new Color(img.getPixel(x, y));
    }

    private void calculateHeadSize() {
        int sizeX = this.headSizeX * 16 + (this.headSizeX - 1) * 2;
        int sizeY = this.headSizeY * 16 + (this.headSizeY - 1) * 2;
        this.headX = this.guiLeft + (256 - sizeX) / 2;
        this.headY = this.guiTop + (222 - sizeY) / 2;
        this.endHeadX = this.headX + sizeX;
        this.endHeadY = this.headY + sizeY;
        switch (this.skinPart.getSizeX() * 100 + this.skinPart.getSizeY()) {
            case 312: 
            case 412: 
            case 812: {
                this.scale = 0.7f;
                break;
            }
            default: {
                this.scale = 1.0f;
            }
        }
    }

    private Point calculatePoint(double mouseX, double mouseY) {
        Vector2f scaled = this.scalePoint(this.headX, this.headY);
        int x = (int)((mouseX - (double)scaled.x) / (double)(18.0f * this.scale));
        int y = (int)((mouseY - (double)scaled.y) / (double)(18.0f * this.scale));
        return new Point(this.skinPart.getX() + x, this.skinPart.getY() + y);
    }

    public boolean checkBounds(float x, float y, float minX, float maxX, float minY, float maxY) {
        Vector2f minVec = this.scalePoint(minX, minY);
        Vector2f maxVec = this.scalePoint(maxX, maxY);
        return x >= minVec.x && x <= maxVec.x && y >= minVec.y && y <= maxVec.y;
    }

    private Vector2f scalePoint(float x, float y) {
        PoseStack pose = new PoseStack();
        pose.pushPose();
        pose.translate(((float)this.width - (float)this.width * this.scale) / 2.0f, ((float)this.height - (float)this.height * this.scale) / 2.0f, 0.0f);
        pose.scale(this.scale, this.scale, 1.0f);
        Vector3f head = pose.last().pose().transformPosition(x, y, 0.0f, new Vector3f());
        pose.popPose();
        return new Vector2f(head.x, head.y);
    }

    private Button createModeButton(int x, int y, Mode buttonMode) {
        TintedOverlayImageButton imageButton = new TintedOverlayImageButton(x, y, 20, 20, buttonMode.getSprites(), buttonMode.getColorOverlay(), button -> {
            this.mode = buttonMode;
            this.modeButtons.forEach((m, b) -> {
                b.active = true;
            });
            button.active = false;
        });
        imageButton.setColorSupplier(() -> this.mod.getModVariables().getFinalColor().getRGB());
        imageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)("tooltip.glowingeyes.editor." + buttonMode.name().toLowerCase()))));
        this.modeButtons.put(buttonMode, (Button)imageButton);
        return imageButton;
    }

    public static enum Mode {
        BRUSH(TextureLocations.BRUSH_BUTTON, TextureLocations.BRUSH_COLOR_OVERLAY, (screen, mouseX, mouseY, button) -> {
            Point point = screen.calculatePoint(mouseX, mouseY);
            if (button == 0) {
                Color finalColor = screen.mod.getModVariables().getFinalColor();
                screen.pixels.put(new Point(point.getX(), point.getY()), finalColor.withAlpha(200));
            } else if (button == 1) {
                screen.pixels.remove(new Point(point.getX(), point.getY()));
            } else if (button == 2) {
                screen.mod.getModVariables().setFinalColor(screen.getTexturePixelColor(((EyesEditorScreen)screen).minecraft.player.getSkin().body().texturePath(), 64, 64, point.getX(), point.getY()));
                screen.openedAt = System.currentTimeMillis();
            }
        }),
        ERASER(TextureLocations.ERASER_BUTTON, null, (screen, mouseX, mouseY, button) -> {
            Point point = screen.calculatePoint(mouseX, mouseY);
            screen.pixels.remove(new Point(point.getX(), point.getY()));
        }),
        PICKER(TextureLocations.PIPETTE_BUTTON, TextureLocations.PIPETTE_COLOR_OVERLAY, (screen, mouseX, mouseY, button) -> {
            Point point = screen.calculatePoint(mouseX, mouseY);
            Color color = screen.getTexturePixelColor(((EyesEditorScreen)screen).minecraft.player.getSkin().body().texturePath(), 64, 64, point.getX(), point.getY());
            screen.mod.getModVariables().setFinalColor(color);
            Button brushButton = screen.modeButtons.get((Object)BRUSH);
            brushButton.onPress((InputWithModifiers)new MouseButtonEvent((double)(brushButton.getX() + 1), (double)(brushButton.getY() + 1), new MouseButtonInfo(0, 0)));
            screen.modeButtons.forEach((mode, b) -> b.setFocused(false));
            screen.openedAt = System.currentTimeMillis();
        }),
        FILL(TextureLocations.FILL_BUCKET_BUTTON, TextureLocations.FILL_BUCKET_COLOR_OVERLAY, (screen, mouseX, mouseY, button) -> {
            Point point = screen.calculatePoint(mouseX, mouseY);
            Color color = screen.getTexturePixelColor(((EyesEditorScreen)screen).minecraft.player.getSkin().body().texturePath(), 64, 64, point.getX(), point.getY());
            Color finalColor = screen.mod.getModVariables().getFinalColor().withAlpha(200);
            Stack<Point> stack = new Stack<Point>();
            HashSet<Point> visitedPoints = new HashSet<Point>();
            stack.push(point);
            visitedPoints.add(point);
            int minX = screen.skinPart.getX();
            int minY = screen.skinPart.getY();
            int maxX = minX + screen.skinPart.getSizeX();
            int maxY = minY + screen.skinPart.getSizeY();
            while (!stack.isEmpty()) {
                Point south;
                Point north;
                Point west;
                Color pixelColor;
                Point p = (Point)stack.pop();
                int x = p.getX();
                int y = p.getY();
                if (x < minX || x >= maxX || y < minY || y >= maxY || !(pixelColor = screen.getTexturePixelColor(((EyesEditorScreen)screen).minecraft.player.getSkin().body().texturePath(), 64, 64, x, y)).equals(color)) continue;
                screen.pixels.put(new Point(p.getX(), p.getY()), finalColor);
                Point east = new Point(x + 1, y);
                if (!visitedPoints.contains(east)) {
                    stack.push(east);
                    visitedPoints.add(east);
                }
                if (!visitedPoints.contains(west = new Point(x - 1, y))) {
                    stack.push(west);
                    visitedPoints.add(west);
                }
                if (!visitedPoints.contains(north = new Point(x, y + 1))) {
                    stack.push(north);
                    visitedPoints.add(north);
                }
                if (visitedPoints.contains(south = new Point(x, y - 1))) continue;
                stack.push(south);
                visitedPoints.add(south);
            }
        });

        private final WidgetSprites sprites;
        private final ButtonPressCallback onButtonPress;
        private final ResourceLocation colorOverlay;

        private Mode(WidgetSprites sprites, ResourceLocation colorOverlay, ButtonPressCallback onButtonPress) {
            this.sprites = sprites;
            this.onButtonPress = onButtonPress;
            this.colorOverlay = colorOverlay;
        }

        public WidgetSprites getSprites() {
            return this.sprites;
        }

        public void onButtonPress(EyesEditorScreen screen, double mouseX, double mouseY, int button) {
            this.onButtonPress.onButtonPress(screen, mouseX, mouseY, button);
        }

        public ResourceLocation getColorOverlay() {
            return this.colorOverlay;
        }

        @FunctionalInterface
        public static interface ButtonPressCallback {
            public void onButtonPress(EyesEditorScreen var1, double var2, double var4, int var6);
        }
    }
}

