/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.button;

import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class BigSelectableButton
extends Button {
    public static final int WIDTH = 128;
    public static final int HEIGHT = 29;
    private static final int ACTIVE_COLOR = -1;
    private static final int NOT_ACTIVE_COLOR = -6250336;
    protected boolean isSelected = false;

    public BigSelectableButton(int x, int y, Component buttonText, Button.OnPress pressedAction) {
        this(x, y, buttonText, pressedAction, DEFAULT_NARRATION);
    }

    public BigSelectableButton(int x, int y, Component buttonText, Button.OnPress pressedAction, Button.CreateNarration createNarration) {
        super(x, y, 128, 29, buttonText, pressedAction, createNarration);
    }

    public void renderWidget(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            ResourceLocation sprite = TextureLocations.BIG_BUTTON.get(!this.isSelected() && this.isActive(), this.isHoveredOrFocused());
            ctx.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, this.getX(), this.getY(), 128, 29, ARGB.white((float)this.alpha));
            Color color = new Color(this.active ? -1 : -6250336);
            this.renderString(ctx, mc.font, color.withAlpha(this.alpha).getRGB());
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void toggleSelected() {
        this.isSelected = !this.isSelected;
    }
}

