/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.preset;

import me.andreasmelone.glowingeyes.client.presets.PresetManager;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class CreatePresetScreen
extends Screen {
    private static final int UI_WIDTH = 200;
    private static final int UI_HEIGHT = 118;
    private static final int TEXT_Y = 10;
    private static final int NAME_FIELD_Y = 45;
    private static final int NAME_FIELD_HEIGHT = 20;
    private static final int PADDING_X = 20;
    private static final int BUTTON_SPACING = 5;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_Y = 78;
    private int guiLeft;
    private int guiTop;
    private EditBox nameField;
    private final Screen parent;

    public CreatePresetScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
    }

    public void init() {
        super.init();
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.parent.clearFocus();
        }
        this.guiLeft = (this.width - 200) / 2;
        this.guiTop = (this.height - 118) / 2;
        this.nameField = new EditBox(this.font, this.guiLeft + 20, this.guiTop + 45, 160, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.nameField);
        int buttonWidth = 75;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.create"), button -> {
            PresetManager.getInstance().createPreset(this.nameField.getValue(), GlowingEyesComponent.getGlowingEyesMap((Player)Minecraft.getInstance().player));
            Minecraft.getInstance().setScreen(this.parent);
        }).pos(this.guiLeft + 20, this.guiTop + 78).size(buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.cancel"), button -> Minecraft.getInstance().setScreen(this.parent)).pos(this.guiLeft + 20 + 10 + buttonWidth, this.guiTop + 78).size(buttonWidth, 20).build());
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.render(ctx, 0, 0, partialTicks);
            GuiUtil.drawTransparentBlack(ctx);
        } else {
            super.renderBackground(ctx, mouseX, mouseY, partialTicks);
        }
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_SLIM, this.guiLeft, this.guiTop, 200, 118);
        ctx.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.glowingeyes.create.title"), this.width / 2, this.guiTop + 10, Color.WHITE.getRGB());
        super.render(ctx, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTick) {
    }
}

