/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.preset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.andreasmelone.glowingeyes.client.gui.button.PresetButton;
import me.andreasmelone.glowingeyes.client.gui.preset.ConfirmDeletionScreen;
import me.andreasmelone.glowingeyes.client.gui.preset.CreatePresetScreen;
import me.andreasmelone.glowingeyes.client.gui.preset.EditPresetScreen;
import me.andreasmelone.glowingeyes.client.presets.Preset;
import me.andreasmelone.glowingeyes.client.presets.PresetManager;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PresetsScreen
extends Screen {
    public static final int EDIT_BUTTON_SPACING = 2;
    private static final int UI_WIDTH = 256;
    private static final int UI_HEIGHT = 222;
    private static final int PRESETS_OFFSET_X = 15;
    private static final int PRESETS_OFFSET_Y = 18;
    private static final int PRESETBOX_OFFSET_X = -7;
    private static final int PRESETBOX_OFFSET_Y = -6;
    public static final int PAGE_SIZE = 5;
    private static final int PRESET_BUTTON_SPACING = 1;
    private static final int PRESET_BUTTON_TOTAL_HEIGHT = 30;
    private static final int PRESET_BUTTONS_LIST_TOTAL_HEIGHT = 150;
    private static final int THUMB_WIDTH = 5;
    public static final int THUMB_MIN_HEIGHT = 7;
    public static final int THUMB_X_OFFSET = 2;
    private static final int NORMAL_BUTTON_WIDTH = 80;
    private static final int NORMAL_BUTTON_HEIGHT = 20;
    private static final int BUTTONS_X = 166;
    private static final int BUTTONS_Y = 120;
    private static final int BUTTONS_SPACING = 2;
    private static final int NORMAL_BUTTON_TOTAL_HEIGHT = 22;
    private static final int EDIT_BUTTON_Y = 5;
    private static final int PLAYERBOX_X = 110;
    private static final float PLAYERBOX_ENTITY_OFFSET = 0.0625f;
    public static final int PLAYERBOX_WIDTH = 34;
    public static final int PLAYERBOX_HEIGHT = 45;
    public static final int PLAYERBOX_FINAL_WIDTH = 50;
    public static final int PLAYERBOX_FINAL_HEIGHT = 66;
    public static final int PLAYERBOX_SCALE = 30;
    private int guiLeft;
    private int guiTop;
    private int page = 0;
    private int selectedPreset = -1;
    private boolean toggledState = true;
    private boolean isLocked = false;
    private boolean editing = false;
    private boolean isDraggingThumb = false;
    private Map<Point, Color> savedPixelMap = null;
    private List<PresetButton> presetButtons;
    private Button createEditButton;
    private Button deleteButton;
    private Screen parent;
    private final PresetManager presetManager = PresetManager.getInstance();

    public PresetsScreen() {
        super((Component)Component.empty());
    }

    public PresetsScreen(Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
    }

    public void init() {
        super.init();
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.parent.clearFocus();
        }
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 222) / 2;
        this.presetButtons = new ArrayList<PresetButton>();
        int buttons = 0;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            if (this.parent != null) {
                GlowingEyesComponent.setToggledOn((Player)Minecraft.getInstance().player, this.toggledState);
                if (this.selectedPreset != -1) {
                    this.presetManager.applyPreset(this.selectedPreset);
                }
                this.presetManager.savePresets();
                Minecraft.getInstance().setScreen(this.parent);
            }
        }).pos(this.guiLeft + 166, this.guiTop + 120).size(80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.cancel"), button -> {
            if (this.parent != null) {
                GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, this.savedPixelMap);
                GlowingEyesComponent.setToggledOn((Player)Minecraft.getInstance().player, this.toggledState);
                this.presetManager.savePresets();
                Minecraft.getInstance().setScreen(this.parent);
            }
        }).pos(this.guiLeft + 166, this.guiTop + 120 + ++buttons * 22).size(80, 20).build());
        ++buttons;
        this.createEditButton = Button.builder((Component)Component.translatable((String)"gui.glowingeyes.presets.create"), button -> {
            if (this.editing) {
                EditPresetScreen.askForName(this, this.presetManager.getPreset(this.selectedPreset).getName()).thenAccept(result -> {
                    if (result != null) {
                        this.presetManager.getPreset(this.selectedPreset).setName((String)result);
                        for (PresetButton presetButton : this.presetButtons) {
                            if (PresetManager.getInstance().getId(presetButton.getPreset()) != this.selectedPreset) continue;
                            presetButton.setPreset(this.presetManager.getPreset(this.selectedPreset));
                        }
                        this.unselectPreset();
                    }
                });
            } else {
                Minecraft.getInstance().setScreen((Screen)new CreatePresetScreen(this));
            }
        }).pos(this.guiLeft + 15, this.guiTop + 5 + 180).size(60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.createEditButton);
        this.deleteButton = Button.builder((Component)Component.translatable((String)"gui.glowingeyes.presets.delete"), button -> {
            if (this.selectedPreset != -1) {
                ConfirmDeletionScreen.askToDelete(this, this.presetManager.getPreset(this.selectedPreset).getName()).thenAccept(result -> {
                    if (result.booleanValue()) {
                        this.presetManager.removePreset(this.selectedPreset);
                        this.movePresets(-2);
                    }
                    this.unselectPreset();
                });
            }
        }).pos(this.guiLeft + 15 + 64 + 4, this.guiTop + 5 + 180).size(60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.deleteButton.active = false;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.glowingeyes.presets.lock"), button -> {
            this.isLocked = !this.isLocked;
            button.setMessage((Component)(this.isLocked ? Component.translatable((String)"gui.glowingeyes.presets.unlock") : Component.translatable((String)"gui.glowingeyes.presets.lock")));
        }).pos(this.guiLeft + 166, this.guiTop + 120 + buttons * 22).size(80, 20).build());
        ++buttons;
        if (this.savedPixelMap == null) {
            this.savedPixelMap = GlowingEyesComponent.getGlowingEyesMap((Player)Minecraft.getInstance().player);
            this.toggledState = GlowingEyesComponent.isToggledOn((Player)Minecraft.getInstance().player);
        }
        List<Preset> presets = this.presetManager.getPresets();
        for (int i = 0; i < 5; ++i) {
            Preset preset = PresetsScreen.getOrDefault(presets, i + this.page, null);
            PresetButton presetButton = new PresetButton(this.guiLeft + 15, this.guiTop + 18 + i * 30, preset, button -> {
                if (PresetManager.getInstance().getId(button.getPreset()) == this.selectedPreset) {
                    this.unselectPreset();
                } else {
                    this.selectPreset(PresetManager.getInstance().getId(button.getPreset()));
                }
                boolean hasSelected = false;
                for (PresetButton b : this.presetButtons) {
                    if (b.getPreset() == null) continue;
                    b.setSelected(PresetManager.getInstance().getId(b.getPreset()) == this.selectedPreset);
                    if (!hasSelected) {
                        boolean bl = hasSelected = PresetManager.getInstance().getId(b.getPreset()) == this.selectedPreset;
                    }
                    if (PresetManager.getInstance().getId(b.getPreset()) != this.selectedPreset) continue;
                    GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, b.getPreset().getContent());
                }
                if (!hasSelected) {
                    GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, this.savedPixelMap);
                }
            });
            this.presetButtons.add(presetButton);
            presetButton.setSelected(this.presetManager.getId(preset) == this.selectedPreset);
            this.addRenderableWidget((GuiEventListener)presetButton);
        }
        this.selectPreset(this.selectedPreset);
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.parent != null) {
            this.parent.render(ctx, 0, 0, partialTicks);
            GuiUtil.drawTransparentBlack(ctx);
        } else {
            super.renderBackground(ctx, mouseX, mouseY, partialTicks);
        }
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_BROAD, this.guiLeft, this.guiTop, 256, 222);
        int playerBoxX = this.guiLeft + 166 + 15;
        int playerBoxY = this.guiTop + 110 - 60;
        int middleX = playerBoxX + 25;
        int middleY = playerBoxY + 33;
        ctx.blit(RenderPipelines.GUI_TEXTURED, TextureLocations.UI_PLAYERBOX, playerBoxX, playerBoxY, 0.0f, 0.0f, 50, 66, 34, 45, 64, 64);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)ctx, (int)playerBoxX, (int)playerBoxY, (int)(playerBoxX + 50), (int)(playerBoxY + 66), (int)30, (float)0.0625f, (float)(this.isLocked ? (float)middleX : (float)mouseX), (float)(this.isLocked ? (float)middleY : (float)mouseY), (LivingEntity)Minecraft.getInstance().player);
        ctx.blit(RenderPipelines.GUI_TEXTURED, TextureLocations.UI_PRESETBOX, this.guiLeft + 15 + -7, this.guiTop + 18 + -6, 0.0f, 0.0f, 147, 163, 256, 256);
        if (this.presetManager.getPresets().size() > 5) {
            int heightThumb = this.calculateThumbHeight();
            float yThumb = (float)(this.guiTop + 18) + 150.0f * (float)this.page / (float)this.presetManager.getPresets().size();
            ctx.fill(this.guiLeft + 15 + 128 + 2, (int)yThumb, this.guiLeft + 15 + 128 + 2 + 5, (int)(yThumb + (float)heightThumb), -1);
        }
        super.render(ctx, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        double mouseX = event.x();
        double mouseY = event.y();
        int heightThumb = this.calculateThumbHeight();
        float yThumb = (float)(this.guiTop + 18) + 150.0f * (float)this.page / (float)this.presetManager.getPresets().size();
        float xThumb = this.guiLeft + 15 + 128 + 2;
        if (mouseX >= (double)xThumb && mouseX <= (double)(xThumb + 5.0f) && mouseY >= (double)yThumb && mouseY <= (double)(yThumb + (float)heightThumb)) {
            this.isDraggingThumb = true;
            return true;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        this.isDraggingThumb = false;
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.isDraggingThumb) {
            int presets = this.presetManager.getPresets().size();
            int heightThumb = this.calculateThumbHeight();
            double scaledMouse = event.y() - (double)this.guiTop - 18.0 - (double)heightThumb / 2.0;
            this.movePresets(Mth.floor((double)(scaledMouse / 150.0 * (double)presets)) - this.page);
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int xPresets = this.guiLeft + 15 + -7;
        int yPresets = this.guiTop + 18 + -6;
        if (mouseX >= (double)xPresets && mouseX <= (double)(xPresets + 147) && mouseY >= (double)yPresets && mouseY <= (double)(yPresets + 163)) {
            int scroll = (int)(-scrollY);
            this.movePresets(scroll);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, this.savedPixelMap);
        GlowingEyesComponent.setToggledOn((Player)Minecraft.getInstance().player, this.toggledState);
        this.presetManager.savePresets();
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTick) {
    }

    private int calculateThumbHeight() {
        return Math.max((int)(150.0f * (5.0f / (float)this.presetManager.getPresets().size())), 7);
    }

    private void selectPreset(int preset) {
        if (preset == -1) {
            this.unselectPreset();
            return;
        }
        this.selectedPreset = preset;
        this.deleteButton.active = true;
        this.setEditing(true);
    }

    private void unselectPreset() {
        this.selectedPreset = -1;
        for (PresetButton presetButton : this.presetButtons) {
            presetButton.setSelected(false);
        }
        this.setEditing(false);
        this.deleteButton.active = false;
        GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, this.savedPixelMap);
        GlowingEyesComponent.setToggledOn((Player)Minecraft.getInstance().player, this.toggledState);
    }

    private void setEditing(boolean editing) {
        this.editing = editing;
        if (editing) {
            this.createEditButton.setMessage((Component)Component.translatable((String)"gui.glowingeyes.presets.edit"));
        } else {
            this.createEditButton.setMessage((Component)Component.translatable((String)"gui.glowingeyes.presets.create"));
        }
    }

    private void movePresets(int amount) {
        this.page = Mth.clamp((int)(amount + this.page), (int)0, (int)(this.presetManager.getPresets().size() - 5));
        List<Preset> presets = this.presetManager.getPresets();
        for (int i = 0; i < 5; ++i) {
            if (this.page + i >= presets.size()) {
                this.presetButtons.get((int)i).visible = false;
                continue;
            }
            this.presetButtons.get((int)i).visible = true;
            PresetButton presetButton = this.presetButtons.get(i);
            Preset preset = presets.get(this.page + i);
            presetButton.setPreset(preset);
            presetButton.setSelected(PresetManager.getInstance().getId(preset) == this.selectedPreset);
        }
    }

    private static <T> T getOrDefault(List<T> list, int index, T defaulT) {
        if (list.size() > index && index >= 0) {
            return list.get(index);
        }
        return defaulT;
    }
}

