/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.andreasmelone.glowingeyes.client.gui.skin.ISkinPart;
import me.andreasmelone.glowingeyes.client.gui.skin.SlimSkinPart;
import me.andreasmelone.glowingeyes.common.util.Point;

public enum ClassicSkinPart implements ISkinPart
{
    HEAD_FRESH_MOVES_1(0, true, 8, 8),
    HEAD_TOP(0, true, 8, 8),
    HEAD_BOTTOM(0, true, 8, 8),
    HEAD_FRESH_MOVES_2(0, true, 8, 8),
    HEAD_OVERLAY_FRESH_MOVES_3(0, true, 8, 8),
    HEAD_OVERLAY_TOP(0, true, 8, 8),
    HEAD_OVERLAY_BOTTOM(0, true, 8, 8),
    HEAD_OVERLAY_FRESH_MOVES_4(0, true, 8, 8),
    HEAD_LEFT(1, true, 8, 8),
    HEAD_FRONT(1, true, 8, 8),
    HEAD_BACK(1, true, 8, 8),
    HEAD_RIGHT(1, true, 8, 8),
    HEAD_OVERLAY_RIGHT(1, true, 8, 8),
    HEAD_OVERLAY_FRONT(1, true, 8, 8),
    HEAD_OVERLAY_LEFT(1, true, 8, 8),
    HEAD_OVERLAY_BACK(1, true, 8, 8),
    RIGHT_LEG_EMPTY_1(2, false, 4, 4),
    RIGHT_LEG_TOP(2, true, 4, 4),
    RIGHT_LEG_BOTTOM(2, true, 4, 4),
    RIGHT_LEG_EMPTY_2(2, false, 4, 4),
    TORSO_EMPTY_1(2, false, 4, 4),
    TORSO_TOP(2, true, 8, 4),
    TORSO_BOTTOM(2, true, 8, 4),
    TORSO_EMPTY_2(2, false, 4, 4),
    RIGHT_ARM_EMPTY_1(2, false, 4, 4),
    RIGHT_ARM_TOP(2, true, 4, 4),
    RIGHT_ARM_BOTTOM(2, true, 4, 4),
    RIGHT_LEG_RIGHT(3, true, 4, 12),
    RIGHT_LEG_FRONT(3, true, 4, 12),
    RIGHT_LEG_LEFT(3, true, 4, 12),
    RIGHT_LEG_BACK(3, true, 4, 12),
    TORSO_RIGHT(3, true, 4, 12),
    TORSO_FRONT(3, true, 8, 12),
    TORSO_LEFT(3, true, 4, 12),
    TORSO_BACK(3, true, 8, 12),
    RIGHT_ARM_RIGHT(3, true, 4, 12),
    RIGHT_ARM_FRONT(3, true, 4, 12),
    RIGHT_ARM_LEFT(3, true, 4, 12),
    RIGHT_ARM_BACK(3, true, 4, 12),
    RIGHT_LEG_OVERLAY_EMPTY_1(4, false, 4, 4),
    RIGHT_LEG_OVERLAY_TOP(4, true, 4, 4),
    RIGHT_LEG_OVERLAY_BOTTOM(4, true, 4, 4),
    RIGHT_LEG_OVERLAY_EMPTY_2(4, false, 4, 4),
    TORSO_OVERLAY_EMPTY_1(4, false, 4, 4),
    TORSO_OVERLAY_TOP(4, true, 8, 4),
    TORSO_OVERLAY_BOTTOM(4, true, 8, 4),
    TORSO_OVERLAY_EMPTY_2(4, false, 4, 4),
    RIGHT_ARM_OVERLAY_EMPTY_1(4, false, 4, 4),
    RIGHT_ARM_OVERLAY_TOP(4, true, 4, 4),
    RIGHT_ARM_OVERLAY_BOTTOM(4, true, 4, 4),
    RIGHT_LEG_OVERLAY_RIGHT(5, true, 4, 12),
    RIGHT_LEG_OVERLAY_FRONT(5, true, 4, 12),
    RIGHT_LEG_OVERLAY_LEFT(5, true, 4, 12),
    RIGHT_LEG_OVERLAY_BACK(5, true, 4, 12),
    TORSO_OVERLAY_RIGHT(5, true, 4, 12),
    TORSO_OVERLAY_FRONT(5, true, 8, 12),
    TORSO_OVERLAY_LEFT(5, true, 4, 12),
    TORSO_OVERLAY_BACK(5, true, 8, 12),
    RIGHT_ARM_OVERLAY_RIGHT(5, true, 4, 12),
    RIGHT_ARM_OVERLAY_FRONT(5, true, 4, 12),
    RIGHT_ARM_OVERLAY_LEFT(5, true, 4, 12),
    RIGHT_ARM_OVERLAY_BACK(5, true, 4, 12),
    LEFT_LEG_OVERLAY_EMPTY_1(6, false, 4, 4),
    LEFT_LEG_OVERLAY_TOP(6, true, 4, 4),
    LEFT_LEG_OVERLAY_BOTTOM(6, true, 4, 4),
    LEFT_LEG_OVERLAY_EMPTY_2(6, false, 4, 4),
    LEFT_LEG_EMPTY_1(6, false, 4, 4),
    LEFT_LEG_TOP(6, true, 4, 4),
    LEFT_LEG_BOTTOM(6, true, 4, 4),
    LEFT_LEG_EMPTY_2(6, false, 4, 4),
    LEFT_ARM_EMPTY_1(6, false, 4, 4),
    LEFT_ARM_TOP(6, true, 4, 4),
    LEFT_ARM_BOTTOM(6, true, 4, 4),
    LEFT_ARM_EMPTY_2(6, false, 4, 4),
    LEFT_ARM_OVERLAY_EMPTY_1(6, false, 4, 4),
    LEFT_ARM_OVERLAY_TOP(6, true, 4, 4),
    LEFT_ARM_OVERLAY_BOTTOM(6, true, 4, 4),
    LEFT_ARM_OVERLAY_EMPTY_2(6, false, 4, 4),
    LEFT_LEG_OVERLAY_RIGHT(7, true, 4, 12),
    LEFT_LEG_OVERLAY_FRONT(7, true, 4, 12),
    LEFT_LEG_OVERLAY_LEFT(7, true, 4, 12),
    LEFT_LEG_OVERLAY_BACK(7, true, 4, 12),
    LEFT_LEG_RIGHT(7, true, 4, 12),
    LEFT_LEG_FRONT(7, true, 4, 12),
    LEFT_LEG_LEFT(7, true, 4, 12),
    LEFT_LEG_BACK(7, true, 4, 12),
    LEFT_ARM_RIGHT(7, true, 4, 12),
    LEFT_ARM_FRONT(7, true, 4, 12),
    LEFT_ARM_LEFT(7, true, 4, 12),
    LEFT_ARM_BACK(7, true, 4, 12),
    LEFT_ARM_OVERLAY_RIGHT(7, true, 4, 12),
    LEFT_ARM_OVERLAY_FRONT(7, true, 4, 12),
    LEFT_ARM_OVERLAY_LEFT(7, true, 4, 12),
    LEFT_ARM_OVERLAY_BACK(7, true, 4, 12);

    private static final Map<Point, ClassicSkinPart> POINT_TO_SKIN_PART_MAP;
    private static final Map<Integer, List<ClassicSkinPart>> ROW_MAP;
    private static final Map<Integer, Integer> ROW_Y_MAP;
    private final int row;
    private final boolean containsData;
    private final int sizeX;
    private final int sizeY;
    private int x = -1;
    private int y = -1;

    private ClassicSkinPart(int row, boolean containsData, int sizeX, int sizeY) {
        this.row = row;
        this.containsData = containsData;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public boolean containsData() {
        return this.containsData;
    }

    @Override
    public int getX() {
        if (this.x == -1) {
            this.x = 0;
            for (ClassicSkinPart part : ClassicSkinPart.getRow(this.row)) {
                if (part == this) break;
                this.x += part.getSizeX();
            }
        }
        return this.x;
    }

    @Override
    public int getY() {
        if (this.y == -1) {
            this.y = ClassicSkinPart.getRowY(this.getRow());
        }
        return this.y;
    }

    @Override
    public boolean isSlim() {
        return false;
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public String getTranslationKey() {
        return "gui.glowingeyes." + this.toString().toLowerCase(Locale.ROOT).replace("_", "");
    }

    public static int getRowY(int row) {
        return ROW_Y_MAP.getOrDefault(row, -1);
    }

    public static List<ClassicSkinPart> getRow(int row) {
        return ROW_MAP.getOrDefault(row, Collections.emptyList());
    }

    public static Map<Integer, List<? extends ISkinPart>> getRows() {
        HashMap<Integer, List<? extends ISkinPart>> rows = new HashMap<Integer, List<? extends ISkinPart>>();
        ROW_MAP.forEach((key, value) -> rows.put((Integer)key, new ArrayList(value)));
        return rows;
    }

    public static ClassicSkinPart getFromCoordinates(int x, int y) {
        if (x < 0 || y < 0 || y > 63 || x > 63) {
            return null;
        }
        return POINT_TO_SKIN_PART_MAP.get(new Point(x, y));
    }

    public static ISkinPart getPart(ClassicSkinPart part, boolean isSlim) {
        if (!isSlim) {
            return part;
        }
        return SlimSkinPart.valueOf(part.name());
    }

    static {
        POINT_TO_SKIN_PART_MAP = new HashMap<Point, ClassicSkinPart>();
        ROW_MAP = new HashMap<Integer, List<ClassicSkinPart>>();
        ROW_Y_MAP = new HashMap<Integer, Integer>();
        for (ClassicSkinPart part : ClassicSkinPart.values()) {
            ROW_MAP.computeIfAbsent(part.row, k -> new ArrayList()).add(part);
        }
        int currentY = 0;
        int previousMaxHeight = 0;
        for (int row = 0; row < 8; ++row) {
            int currentX = 0;
            int maxHeightInRow = 0;
            for (ClassicSkinPart part : ClassicSkinPart.getRow(row)) {
                for (int dx = 0; dx < part.getSizeX(); ++dx) {
                    for (int dy = 0; dy < part.getSizeY(); ++dy) {
                        POINT_TO_SKIN_PART_MAP.put(new Point(currentX + dx, currentY + dy), part);
                    }
                }
                currentX += part.getSizeX();
                maxHeightInRow = Math.max(maxHeightInRow, part.getSizeY());
            }
            ROW_Y_MAP.put(row, previousMaxHeight + ROW_Y_MAP.getOrDefault(row - 1, 0));
            previousMaxHeight = maxHeightInRow;
            currentY += maxHeightInRow;
        }
    }
}

