/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.skin;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.andreasmelone.glowingeyes.client.gui.skin.ClassicSkinPart;
import me.andreasmelone.glowingeyes.client.gui.skin.ISkinPart;
import me.andreasmelone.glowingeyes.client.gui.skin.SlimSkinPart;
import me.andreasmelone.glowingeyes.client.gui.widget.CursorSpaceWidget;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.SkinUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class SkinPartSelectorScreen
extends Screen {
    private static final int TEXTURE_WIDTH = 221;
    private static final int TEXTURE_HEIGHT = 222;
    private static final int BUTTON_X = 197;
    private static final int PADDING_X = 5;
    private static final int PADDING_Y = 5;
    private static final int BUTTON_HEIGHT = 20;
    private int maxTextureWidth;
    private int maxTextureHeight;
    private float textureX;
    private float textureY;
    private int guiLeft;
    private int guiTop;
    private int middle;
    private float factorX;
    private float factorY;
    private ISkinPart selected;
    private CompletableFuture<ISkinPart> future;
    private CursorSpaceWidget cursorSpaceWidget;
    private final int rows = 7;
    private final Screen parent;
    private final ResourceLocation skinTexture;
    private final Color overlayColor = new Color(255, 255, 255, 120);

    protected SkinPartSelectorScreen(Screen parent, ResourceLocation skinTexture, @NotNull ISkinPart selected) {
        super((Component)Component.empty());
        this.parent = parent;
        this.skinTexture = skinTexture;
        this.selected = selected;
    }

    protected void init() {
        super.init();
        if (this.parent != null) {
            this.parent.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.parent.clearFocus();
        }
        this.guiLeft = (this.width - 221) / 2;
        this.guiTop = (this.height - 222) / 2;
        int paddedWidth = 211;
        int paddedHeight = 212;
        float scaleX = (float)paddedWidth / 64.0f;
        float scaleY = (float)paddedHeight / (float)ISkinPart.getRowY(this.rows, this.selected.isSlim());
        float scaleFactor = Math.min(scaleX, scaleY);
        this.maxTextureWidth = (int)(64.0f * scaleFactor);
        this.maxTextureHeight = (int)((float)ISkinPart.getRowY(this.rows, this.selected.isSlim()) * scaleFactor);
        this.textureX = (float)this.guiLeft + (float)(221 - this.maxTextureWidth) / 2.0f;
        this.textureY = (float)this.guiTop + (float)(222 - this.maxTextureHeight) / 2.0f - 3.0f;
        this.factorX = 64.0f / (float)this.maxTextureWidth;
        this.factorY = (float)ISkinPart.getRowY(this.rows, this.selected.isSlim()) / (float)this.maxTextureHeight;
        this.middle = this.guiLeft + 110;
        this.cursorSpaceWidget = new CursorSpaceWidget((int)this.textureX, (int)this.textureY, this.maxTextureWidth, this.maxTextureHeight, (arg_0, arg_1) -> ((SkinPartSelectorScreen)this).mouseMoved(arg_0, arg_1), this::mouseClicked);
        this.addRenderableWidget(this.cursorSpaceWidget);
        int width = this.middle - this.guiLeft - 7;
        int doneX = this.guiLeft + 5;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            if (this.selected == null) {
                return;
            }
            this.future.complete(this.selected);
            this.minecraft.setScreen(this.parent);
        }).pos(doneX, this.guiTop + 197).size(width, 20).build());
        int cancelX = this.middle + 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> {
            this.future.complete(null);
            this.minecraft.setScreen(this.parent);
        }).pos(cancelX, this.guiTop + 197).size(width, 20).build());
    }

    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        ISkinPart part;
        if (this.parent != null) {
            this.parent.render(ctx, 0, 0, partialTicks);
            GuiUtil.drawTransparentBlack(ctx);
        } else {
            super.renderBackground(ctx, mouseX, mouseY, partialTicks);
        }
        GuiUtil.drawBackground(ctx, TextureLocations.UI_BACKGROUND_BIG, this.guiLeft, this.guiTop, 221, 222);
        ctx.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"gui.glowingeyes.skinpartselection"), this.middle, this.guiTop + 7, Color.WHITE.getRGB());
        ctx.pose().pushMatrix();
        ctx.pose().translate(this.textureX, this.textureY);
        ctx.blit(RenderPipelines.GUI_TEXTURED, this.skinTexture, 0, 0, 0.0f, 0.0f, this.maxTextureWidth, this.maxTextureHeight, 64, ISkinPart.getRowY(this.rows, this.selected.isSlim()), 64, 64);
        ctx.pose().popMatrix();
        double cursorX = this.cursorSpaceWidget.isUsed() ? this.cursorSpaceWidget.getCursorX() : (double)mouseX;
        double cursorY = this.cursorSpaceWidget.isUsed() ? this.cursorSpaceWidget.getCursorY() : (double)mouseY;
        int textureMouseX = (int)((cursorX - (double)this.textureX) * (double)this.factorX);
        int textureMouseY = (int)((cursorY - (double)this.textureY) * (double)this.factorY);
        if (this.selected != null) {
            ctx.pose().pushMatrix();
            ctx.pose().translate((float)((double)(this.textureX + (float)this.selected.getX() / this.factorX) - 0.25), (float)((double)(this.textureY + (float)this.selected.getY() / this.factorY) - 0.25));
            ctx.fill(0, 0, (int)((float)this.selected.getSizeX() / this.factorX), (int)((float)this.selected.getSizeY() / this.factorY), this.overlayColor.getRGB());
            GuiUtil.drawOutline(ctx, 0, 0, (int)((float)this.selected.getSizeX() / this.factorY) + 1, (int)((float)this.selected.getSizeY() / this.factorX) + 1, Color.BLACK.getRGB());
            ctx.pose().popMatrix();
        }
        if (textureMouseX >= 0 && textureMouseX <= 63 && textureMouseY >= 0 && textureMouseY <= 63 && (part = ISkinPart.getFromCoordinates(textureMouseX, textureMouseY, this.selected.isSlim())) != null && part.containsData() && part.getRow() < this.rows) {
            int x = part.getX();
            int y = part.getY();
            ctx.pose().pushMatrix();
            ctx.pose().translate(this.textureX, this.textureY);
            ctx.pose().scale(1.0f / this.factorX, 1.0f / this.factorY);
            ctx.fill(x, y, x + part.getSizeX(), y + part.getSizeY(), this.overlayColor.getRGB());
            ctx.pose().popMatrix();
            List<ClientTooltipComponent> tooltipList = List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)part.getTranslationKey()).getVisualOrderText()));
            ctx.renderTooltip(this.minecraft.font, tooltipList, (int)cursorX, (int)cursorY, DefaultTooltipPositioner.INSTANCE, null);
        }
        super.render(ctx, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        double mouseX = event.x();
        double mouseY = event.y();
        int button = event.button();
        int textureMouseX = (int)((mouseX - (double)this.textureX) * (double)this.factorX);
        int textureMouseY = (int)((mouseY - (double)this.textureY) * (double)this.factorY);
        ISkinPart part = ISkinPart.getFromCoordinates(textureMouseX, textureMouseY, this.selected.isSlim());
        if (part != null && part.containsData() && part.getRow() < this.rows && button == 0) {
            this.selected = part;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public void renderBackground(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
    }

    public void onClose() {
        super.onClose();
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
        }
    }

    public static CompletableFuture<ISkinPart> create(Screen parent, ResourceLocation skin, ISkinPart selected) {
        CompletableFuture<ISkinPart> future = new CompletableFuture<ISkinPart>();
        SkinPartSelectorScreen screen = new SkinPartSelectorScreen(parent, skin, selected);
        screen.future = future;
        Minecraft.getInstance().setScreen((Screen)screen);
        return future;
    }

    public static CompletableFuture<ISkinPart> create(Screen parent, ResourceLocation skin) {
        return SkinPartSelectorScreen.create(parent, skin, (ISkinPart)((Object)(SkinUtil.isSlim() ? SlimSkinPart.HEAD_FRONT : ClassicSkinPart.HEAD_FRONT)));
    }
}

