/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.util.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorPickerWidget
extends AbstractWidget
implements GuiEventListener {
    private static final int CURSOR_OFFSET_X = 5;
    private static final int CURSOR_OFFSET_Y = 5;
    private static final int HOVERED_COLOR = -1;
    private static final int INACTIVE_COLOR = -16777216;
    private static final float INCREMENT_CTRL_PRESS_FACTOR = 3.5f;
    private static final float INCREMENT_NORMAL_FACTOR = 1.0f;
    private static final float INCREMENT = 0.003921569f;
    private float hue;
    private float brightness;
    private float saturation;
    private boolean isShiftPressed = false;
    private final List<Consumer<ColorPickerWidget>> onChangeListeners = new ArrayList<Consumer<ColorPickerWidget>>();

    public ColorPickerWidget(int x, int y, int width, int height, float hue, float brightness, float saturation) {
        super(x, y, width, height, (Component)Component.empty());
        this.hue = hue;
        this.brightness = brightness;
        this.saturation = saturation;
    }

    public void renderWidget(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float deltaTime) {
        GuiUtil.drawColorSquare(ctx, this.getX(), this.getY(), this.width, this.height, Color.HSBtoRGB(this.hue, 1.0f, 1.0f));
        GuiUtil.drawOutline(ctx, this.getX() - 1, this.getY() - 1, this.width + 2, this.height + 2, this.isHoveredOrFocused() ? -1 : -16777216);
        ctx.pose().pushMatrix();
        ctx.pose().translate(this.getCursorX(), this.getCursorY());
        ctx.pose().translate(-5.0f + 2.0f * (1.0f - this.saturation), -5.0f + 2.0f * this.brightness);
        ctx.blit(RenderPipelines.GUI_TEXTURED, TextureLocations.CURSOR, 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
        ctx.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (event.button() == 0 && this.isInbounds((int)event.x(), (int)event.y())) {
            return this.mouseDragged(event, 0.0, 0.0);
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.isInbounds((int)event.x(), (int)event.y())) {
            this.setCursorX((float)event.x());
            this.setCursorY((float)event.y());
            this.triggerChange();
        } else {
            float newX = (float)Math.max((double)this.getX(), Math.min(event.x(), (double)(this.getX() + this.width)));
            float newY = (float)Math.max((double)this.getY(), Math.min(event.y(), (double)(this.getY() + this.height)));
            this.setCursorX(newX);
            this.setCursorY(newY);
            this.triggerChange();
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isInbounds((int)mouseX, (int)mouseY)) {
            if (this.isShiftPressed) {
                scrollX += scrollY;
                scrollY = 0.0;
            }
            this.saturation = (float)Math.clamp((double)this.saturation + scrollX / 1500.0, 0.0, 1.0);
            this.brightness = (float)Math.clamp((double)this.brightness + scrollY / 1500.0, 0.0, 1.0);
            this.triggerChange();
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(KeyEvent event) {
        int keyCode = event.key();
        int modifiers = event.modifiers();
        if (keyCode == 340) {
            this.isShiftPressed = true;
        }
        boolean isCtrlPressed = (modifiers & 2) != 0;
        float increment = 0.003921569f * (isCtrlPressed ? 3.5f : 1.0f);
        if (keyCode == 265) {
            this.brightness = Math.clamp(this.brightness + increment, 0.0f, 1.0f);
            this.triggerChange();
            return true;
        }
        if (keyCode == 264) {
            this.brightness = Math.clamp(this.brightness - increment, 0.0f, 1.0f);
            this.triggerChange();
            return true;
        }
        if (keyCode == 263) {
            this.saturation = Math.clamp(this.saturation - increment, 0.0f, 1.0f);
            this.triggerChange();
            return true;
        }
        if (keyCode == 262) {
            this.saturation = Math.clamp(this.saturation + increment, 0.0f, 1.0f);
            this.triggerChange();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        if (event.key() == 340) {
            this.isShiftPressed = false;
        }
        return super.keyReleased(event);
    }

    public float getCursorX() {
        return (float)this.getX() + this.saturation * (float)this.width;
    }

    public void setCursorX(float cursorX) {
        this.saturation = (cursorX - (float)this.getX()) / (float)this.width;
    }

    public float getCursorY() {
        return (float)this.getY() + (1.0f - this.brightness) * (float)this.height;
    }

    public void setCursorY(float cursorY) {
        this.brightness = -((cursorY - (float)this.getY()) / (float)this.height - 1.0f);
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public void onChange(Consumer<ColorPickerWidget> listener) {
        this.onChangeListeners.add(listener);
    }

    private void triggerChange() {
        this.onChangeListeners.forEach(l -> l.accept(this));
    }

    private boolean isInbounds(int x, int y) {
        return x >= this.getX() && y >= this.getY() && x <= this.getX() + this.width && y <= this.getY() + this.height;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

