/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.andreasmelone.glowingeyes.client.util.GuiUtil;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.util.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorSliderWidget
extends AbstractWidget
implements GuiEventListener {
    private static final int TEXTURE_WIDTH = 16;
    private static final int TEXTURE_HEIGHT = 16;
    private static final int SPRITE_WIDTH = 16;
    private static final int SPRITE_HEIGHT = 3;
    private static final int CURSOR_OFFSET_Y = 2;
    private static final int SPRITE_OFFSET_X = -1;
    private static final int HOVERED_COLOR = -1;
    private static final int INACTIVE_COLOR = -16777216;
    private static final float INCREMENT = 0.0027777778f;
    private static final float INCREMENT_NORMAL_FACTOR = 1.0f;
    private static final float INCREMENT_CTRL_PRESSED_FACTOR = 2.5f;
    private float hue;
    private final List<Consumer<ColorSliderWidget>> onChangeListeners = new ArrayList<Consumer<ColorSliderWidget>>();

    public ColorSliderWidget(int x, int y, int width, int height, float hue) {
        super(x, y, width, height, (Component)Component.empty());
        this.hue = hue;
    }

    public void renderWidget(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float deltaTime) {
        GuiUtil.drawHueBar(ctx, this.getX(), this.getY(), this.width, this.height, Color.HSBtoRGB(this.hue, 1.0f, 1.0f));
        GuiUtil.drawOutline(ctx, this.getX() - 1, this.getY() - 1, this.width + 2, this.height + 2, this.isHoveredOrFocused() ? -1 : -16777216);
        int newSpriteWidth = 14;
        int spriteRatio = newSpriteWidth / 3;
        float xScale = Math.abs((float)this.width / (float)newSpriteWidth);
        float yScale = Math.abs((float)(Math.floor((float)this.width / (float)spriteRatio) / 3.0));
        ctx.pose().pushMatrix();
        ctx.pose().translate((float)this.getX(), this.getCursor());
        ctx.pose().scale(xScale, yScale);
        ctx.pose().translate(-1.0f, -1.0f * (2.0f + -1.0f * this.hue));
        ctx.blit(RenderPipelines.GUI_TEXTURED, TextureLocations.BRIGHTNESS_CURSOR, 0, 0, 0.0f, 0.0f, 16, 3, 16, 16);
        ctx.pose().popMatrix();
    }

    public boolean keyPressed(KeyEvent event) {
        int keyCode = event.key();
        int modifiers = event.modifiers();
        boolean isCtrlPressed = (modifiers & 2) != 0;
        float increment = 0.0027777778f * (isCtrlPressed ? 2.5f : 1.0f);
        if (keyCode == 265) {
            this.hue = ((this.hue + increment) % 1.0f + 1.0f) % 1.0f;
            this.triggerChange();
            return true;
        }
        if (keyCode == 264) {
            this.hue = ((this.hue - increment) % 1.0f + 1.0f) % 1.0f;
            this.triggerChange();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int button = event.button();
        double mouseX = event.x();
        double mouseY = event.y();
        if (button == 0 && this.isInbounds((int)mouseX, (int)mouseY)) {
            return this.mouseDragged(event, 0.0, 0.0);
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        this.setCursor(Math.clamp((long)((int)event.y()), this.getY(), this.getY() + this.height));
        this.triggerChange();
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isInbounds((int)mouseX, (int)mouseY)) {
            this.hue = (float)Math.clamp((double)this.hue + scrollY / 1500.0, 0.0, 1.0);
            this.triggerChange();
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private boolean isInbounds(int x, int y) {
        return x >= this.getX() && y >= this.getY() && x <= this.getX() + this.width && y <= this.getY() + this.height;
    }

    public float getCursor() {
        return (float)this.getY() + (1.0f - this.hue) * (float)this.height;
    }

    public void setCursor(float cursorY) {
        this.hue = 1.0f - (cursorY - (float)this.getY()) / (float)this.height;
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public void onChange(Consumer<ColorSliderWidget> listener) {
        this.onChangeListeners.add(listener);
    }

    private void triggerChange() {
        this.onChangeListeners.forEach(l -> l.accept(this));
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

