/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.gui.widget;

import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CursorSpaceWidget
extends AbstractWidget
implements GuiEventListener {
    private static final int PRIMARY_MOUSE_BUTTON = 0;
    private static final int SECONDARY_MOUSE_BUTTON = 1;
    private static final int MIDDLE_MOUSE_BUTTON = 2;
    private static final float SENSITIVITY = 2.5f;
    private static final int CURSOR_SIZE = 8;
    private static final int CURSOR_OFFSET = 4;
    private double cursorX;
    private double cursorY;
    protected final MouseMovedCallback mouseMovedCallback;
    protected final MouseClickedCallback mouseClickedCallback;

    public CursorSpaceWidget(int x, int y, int width, int height, MouseMovedCallback mouseMovedCallback, MouseClickedCallback mouseClickedCallback) {
        super(x, y, width, height, (Component)Component.empty());
        this.mouseMovedCallback = mouseMovedCallback;
        this.mouseClickedCallback = mouseClickedCallback;
        this.cursorX = x + 4;
        this.cursorY = y + 4;
    }

    public CursorSpaceWidget(int x, int y, int width, int height, MouseMovedCallback mouseMovedCallback) {
        this(x, y, width, height, mouseMovedCallback, (event, button) -> false);
    }

    public CursorSpaceWidget(int x, int y, int width, int height, MouseClickedCallback mouseClickedCallback) {
        this(x, y, width, height, (mouseX, mouseY) -> {}, mouseClickedCallback);
    }

    public CursorSpaceWidget(int x, int y, int width, int height) {
        this(x, y, width, height, (mouseX, mouseY) -> {}, (event, button) -> false);
    }

    protected void renderWidget(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTick) {
        if (!this.isUsed()) {
            return;
        }
        ctx.pose().pushMatrix();
        ctx.pose().translate((float)this.cursorX, (float)this.cursorY);
        ctx.pose().translate(-4.0f, -4.0f);
        ctx.blit(RenderPipelines.CROSSHAIR, TextureLocations.CURSOR, 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
        ctx.pose().popMatrix();
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public boolean keyPressed(KeyEvent event) {
        int keyCode = event.key();
        int modifiers = event.modifiers();
        if (keyCode == 257 || keyCode == 32) {
            boolean isAltPressed = (modifiers & 4) != 0;
            return this.triggerClick(isAltPressed ? 1 : 0);
        }
        if (keyCode == 265) {
            this.cursorY = Math.clamp(this.cursorY - 2.5, (double)this.getY(), (double)(this.getY() + this.height));
            this.triggerChange();
            return true;
        }
        if (keyCode == 264) {
            this.cursorY = Math.clamp(this.cursorY + 2.5, (double)this.getY(), (double)(this.getY() + this.height));
            this.triggerChange();
            return true;
        }
        if (keyCode == 263) {
            this.cursorX = Math.clamp(this.cursorX - 2.5, (double)this.getX(), (double)(this.getX() + this.width));
            this.triggerChange();
            return true;
        }
        if (keyCode == 262) {
            this.cursorX = Math.clamp(this.cursorX + 2.5, (double)this.getX(), (double)(this.getX() + this.width));
            this.triggerChange();
            return true;
        }
        return super.keyPressed(event);
    }

    public double getCursorY() {
        return this.cursorY;
    }

    public double getCursorX() {
        return this.cursorX;
    }

    public boolean isUsed() {
        return this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard();
    }

    private void triggerChange() {
        this.mouseMovedCallback.mouseMoved(this.cursorX, this.cursorY);
    }

    private boolean triggerClick(int button) {
        return this.mouseClickedCallback.mouseClicked(new MouseButtonEvent(this.cursorX, this.cursorY, new MouseButtonInfo(button, 0)), false);
    }

    @FunctionalInterface
    public static interface MouseMovedCallback {
        public void mouseMoved(double var1, double var3);
    }

    @FunctionalInterface
    public static interface MouseClickedCallback {
        public boolean mouseClicked(MouseButtonEvent var1, boolean var2);
    }
}

