/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.presets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import me.andreasmelone.glowingeyes.client.component.eyes.ClientGlowingEyesComponent;
import me.andreasmelone.glowingeyes.client.presets.Preset;
import me.andreasmelone.glowingeyes.client.presets.serialize.GlowingEyesReferences;
import me.andreasmelone.glowingeyes.client.presets.serialize.SchemaV0;
import me.andreasmelone.glowingeyes.client.presets.serialize.fix.IdFormatFix;
import me.andreasmelone.glowingeyes.client.presets.serialize.fix.IdRemovedFix;
import me.andreasmelone.glowingeyes.client.presets.serialize.fix.PointRangeFix;
import me.andreasmelone.glowingeyes.client.presets.serialize.fix.PresetFile;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class PresetManager {
    public static final int DATA_VERSION = 4;
    private static final PresetManager INSTANCE = new PresetManager();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataFixer dfu = PresetManager.createDFU();
    private final File presetStorage = new File("presets.json");
    private final List<Preset> presets = new ArrayList<Preset>();

    public void loadPresets() {
        PresetFile presets;
        if (!this.presetStorage.exists() || !this.presetStorage.isFile()) {
            LOGGER.info("No presets file found, creating a new one");
            this.saveDefaultPresets();
            return;
        }
        try (FileInputStream in = new FileInputStream(this.presetStorage);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String content = sb.toString();
            Dynamic dynamicData = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)content));
            DataResult result = PresetFile.CODEC.decode(dynamicData);
            if (result.error().isPresent()) {
                throw new RuntimeException("Failed to decode preset file " + ((DataResult.Error)result.error().get()).message());
            }
            presets = (PresetFile)result.map(Pair::getFirst).result().orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the JSON file", e);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Presets not found in preset file", e);
        }
        this.presets.clear();
        int version = presets.dataVersion();
        for (Preset preset : presets.presets()) {
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)Preset.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)preset).result().orElse(new JsonObject())));
            DataResult updatedPresetResult = Preset.CODEC.decode(dynamic = this.dfu.update(GlowingEyesReferences.PRESET, dynamic, version, 4));
            if (updatedPresetResult.error().isPresent()) {
                throw new RuntimeException("Was unable to decode updated preset: " + String.valueOf(updatedPresetResult.error().get()));
            }
            Optional updatedPreset = updatedPresetResult.map(Pair::getFirst).result();
            if (updatedPreset.isEmpty()) {
                throw new RuntimeException("Was unable to decode updated preset for unknown reason");
            }
            this.presets.add((Preset)updatedPreset.get());
        }
        LOGGER.info("Loaded {} presets", (Object)this.presets.size());
    }

    public void savePresets() {
        String json = this.serializePresets().toString();
        LOGGER.info("Saving presets file");
        LOGGER.debug("Saving presets file with content: {}", (Object)json);
        try {
            Files.write(this.presetStorage.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not save presets file due to an IOException", (Throwable)e);
        }
    }

    public JsonElement serializePresets() {
        PresetFile presets = new PresetFile(4, new ArrayList<Preset>(this.presets));
        DataResult serializedPresets = PresetFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)presets);
        if (serializedPresets.error().isPresent()) {
            throw new RuntimeException("Couldn't serialize presets " + String.valueOf(serializedPresets.error().get()));
        }
        if (serializedPresets.result().isEmpty()) {
            throw new RuntimeException("Couldn't serialize presets for unknown reason");
        }
        return (JsonElement)serializedPresets.result().get();
    }

    public void saveDefaultPresets() {
        try (InputStream presetStream = this.getClass().getClassLoader().getResourceAsStream("presets.json");){
            if (presetStream == null) {
                LOGGER.error("Could not save default presets file due to it not being found in the jar");
                return;
            }
            Path dest = this.presetStorage.toPath();
            Files.copy(presetStream, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not save default presets file due to an IOException", (Throwable)e);
            return;
        }
        this.loadPresets();
    }

    public List<Preset> getPresets() {
        return new ArrayList<Preset>(this.presets);
    }

    public void applyPreset(int id) {
        if (!this.hasPreset(id)) {
            LOGGER.error("Tried to apply preset with id {}, but it does not exists ", (Object)id);
            return;
        }
        Preset preset = this.presets.get(id);
        GlowingEyesComponent.setGlowingEyesMap((Player)Minecraft.getInstance().player, preset.getContent());
        ClientGlowingEyesComponent.sendUpdate();
    }

    public boolean hasPreset(int id) {
        return this.presets.get(id) != null;
    }

    public Preset getPreset(int id) {
        if (!this.hasPreset(id)) {
            return null;
        }
        return this.presets.get(id);
    }

    public boolean hasPage(int page, int pageSize) {
        return page >= 0 && page <= (this.presets.size() - 1) / pageSize;
    }

    public int addPreset(Preset preset) {
        return this.addPreset(preset, 0);
    }

    private int addPreset(Preset preset, int number) {
        if (this.presets.size() < number) {
            return this.addPreset(preset, number + 1);
        }
        this.presets.add(new Preset(preset.getName(), preset.getContent()));
        return this.presets.size() - 1;
    }

    public int createPreset(String name, Map<Point, Color> content) {
        int minX = 0;
        int minY = 0;
        int maxX = 63;
        int maxY = 63;
        HashMap<Point, Color> contentCopy = new HashMap<Point, Color>(content);
        for (Point point : content.keySet()) {
            if (point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY) continue;
            LOGGER.error("Tried to create preset with name {}, but the content has pixels outside of range {}, {} - {}, {}", new Object[]{name, minX, minY, maxX, maxY});
            contentCopy.remove(point);
        }
        return this.addPreset(new Preset(name, contentCopy));
    }

    public void removePreset(int id) {
        if (!this.hasPreset(id)) {
            return;
        }
        this.presets.remove(id);
    }

    public int getId(Preset preset) {
        for (int i = 0; i < this.presets.size(); ++i) {
            Preset p = this.presets.get(i);
            if (p != preset) continue;
            return i;
        }
        return -1;
    }

    public static PresetManager getInstance() {
        return INSTANCE;
    }

    private static DataFixer createDFU() {
        DataFixerBuilder builder = new DataFixerBuilder(4);
        BiFunction<Integer, Schema, Schema> same = Schema::new;
        builder.addSchema(0, SchemaV0::new);
        Schema schemaV1 = builder.addSchema(1, same);
        builder.addFixer((DataFix)new IdFormatFix(schemaV1, true));
        Schema schemaV2 = builder.addSchema(2, same);
        builder.addFixer((DataFix)new PointRangeFix(schemaV2, true));
        Schema schemaV3 = builder.addSchema(3, same);
        builder.addFixer((DataFix)new IdRemovedFix(schemaV3, true));
        Schema schemaV4 = builder.addSchema(4, same);
        return builder.build().fixer();
    }
}

