/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.presets.serialize.fix;

import com.google.gson.JsonElement;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import me.andreasmelone.glowingeyes.client.presets.serialize.GlowingEyesReferences;
import me.andreasmelone.glowingeyes.common.util.Point;
import org.slf4j.Logger;

public class PointRangeFix
extends DataFix {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;

    public PointRangeFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
        this.name = "Point Range Fix v" + outputSchema.getVersionKey();
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(GlowingEyesReferences.PRESET);
        return this.fixTypeEverywhereTyped(this.name, type, typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Dynamic map = dynamic.get("content").orElseEmptyMap().updateMapValues(pair -> pair.mapFirst(key -> {
                Point oldPoint;
                Point newPoint;
                Optional serializedPoint;
                Optional result = key.asString().result();
                if (result.isPresent() && (serializedPoint = Point.CODEC_STRING.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)(newPoint = new Point((oldPoint = (Point)Point.CODEC_STRING.decode(key).map(Pair::getFirst).result().orElseThrow()).getX() + 8, oldPoint.getY() + 8))).result()).isPresent()) {
                    return dynamic.createString(((JsonElement)serializedPoint.get()).getAsString());
                }
                return key;
            }));
            return dynamic.remove("content").set("content", map);
        }));
    }
}

