/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.List;
import java.util.Objects;
import me.andreasmelone.glowingeyes.client.render.PipelineManager;
import me.andreasmelone.glowingeyes.client.util.TextureLocations;
import me.andreasmelone.glowingeyes.common.util.Color;
import me.andreasmelone.glowingeyes.common.util.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class GuiUtil {
    public static void drawBackground(GuiGraphics guiGraphics, ResourceLocation backgroundTexture, int x, int y, int width, int height) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, backgroundTexture, x, y, 0.0f, 0.0f, width, height, 256, 256);
    }

    public static void drawTransparentBlack(GuiGraphics ctx) {
        ctx.fill(0, 0, ctx.guiWidth(), ctx.guiHeight(), -1157627904);
    }

    public static WidgetSprites createSprites(String namespace, String location1, String location2) {
        return new WidgetSprites(Util.id(namespace, location1), Util.id(namespace, location2));
    }

    public static WidgetSprites createSprites(String namespace, String location1, String location2, String location3) {
        return new WidgetSprites(Util.id(namespace, location1), Util.id(namespace, location2), Util.id(namespace, location3));
    }

    public static WidgetSprites createSprites(String namespace, String enabled, String disabled, String enabledHighlighted, String disabledHighlighted) {
        return new WidgetSprites(Util.id(namespace, enabled), Util.id(namespace, disabled), Util.id(namespace, enabledHighlighted), Util.id(namespace, disabledHighlighted));
    }

    public static int drawWrappedText(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int maxWidth, int color) {
        List lines = font.split((FormattedText)text, maxWidth);
        Objects.requireNonNull(font);
        int lineHeight = 9;
        for (int i = 0; i < lines.size(); ++i) {
            guiGraphics.drawCenteredString(font, (FormattedCharSequence)lines.get(i), x, y + i * lineHeight, color);
        }
        return lines.size();
    }

    public static void drawCursorPos(GuiGraphics ctx, Font font, int mouseX, int mouseY) {
        ctx.drawString(font, "x: " + mouseX + ", y: " + mouseY, 10, 10, Color.WHITE.getRGB());
    }

    public static void blitTintedSprite(GuiGraphics ctx, RenderPipeline pipeline, ResourceLocation spriteLocation, int x, int y, int width, int height, int color) {
        ctx.blitSprite(pipeline, spriteLocation, x, y, width, height, color);
    }

    public static void drawColorSquare(GuiGraphics ctx, int x, int y, int width, int height, int color) {
        ctx.blit(PipelineManager.COLOR_SQUARE_SHADER, TextureLocations.CURSOR, x, y, 0.0f, 0.0f, width, height, width, height, color);
    }

    public static void drawHueBar(GuiGraphics ctx, int x, int y, int width, int height, int color) {
        ctx.blit(PipelineManager.HUE_BAR_SHADER, TextureLocations.CURSOR, x, y, 0.0f, 0.0f, width, height, width, height, color);
    }

    public static void drawOutline(GuiGraphics ctx, int x, int y, int width, int height, int color) {
        ctx.fill(x, y, x + width, y + 1, color);
        ctx.fill(x, y + height - 1, x + width, y + height, color);
        ctx.fill(x, y + 1, x + 1, y + height - 1, color);
        ctx.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

