/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.client.util.color;

import java.util.function.BiFunction;
import java.util.function.Function;
import me.andreasmelone.glowingeyes.common.util.Color;

public enum ColorType {
    RED(color -> String.valueOf(color.getRed()), (color, value) -> new Color(Math.max(0, Math.min(255, value)), color.getGreen(), color.getBlue()), string -> {
        int val = Integer.parseInt(string);
        return Math.max(0, Math.min(255, val));
    }),
    GREEN(color -> String.valueOf(color.getGreen()), (color, value) -> new Color(color.getRed(), Math.max(0, Math.min(255, value)), color.getBlue()), string -> {
        int val = Integer.parseInt(string);
        return Math.max(0, Math.min(255, val));
    }),
    BLUE(color -> String.valueOf(color.getBlue()), (color, value) -> new Color(color.getRed(), color.getGreen(), Math.max(0, Math.min(255, value))), string -> {
        int val = Integer.parseInt(string);
        return Math.max(0, Math.min(255, val));
    }),
    HEX(color -> String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()), (color, hexValue) -> {
        int r = hexValue >> 16 & 0xFF;
        int g = hexValue >> 8 & 0xFF;
        int b = hexValue & 0xFF;
        return new Color(r, g, b);
    }, string -> {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.length() == 6) {
            return Integer.parseInt(string, 16);
        }
        throw new NumberFormatException("Invalid HEX format");
    }),
    HUE(color -> String.valueOf(Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0] * 360.0f), (color, value) -> {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor((float)value.intValue() / 360.0f, hsb[1], hsb[2]);
    }, string -> {
        float val = Float.parseFloat(string);
        return Math.round(Math.max(0.0f, Math.min(360.0f, val)));
    }),
    SATURATION(color -> String.valueOf(Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[1] * 100.0f), (color, value) -> {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], (float)value.intValue() / 100.0f, hsb[2]);
    }, string -> {
        float val = Float.parseFloat(string);
        return Math.round(Math.max(0.0f, Math.min(100.0f, val)));
    }),
    BRIGHTNESS(color -> String.valueOf(Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[2] * 100.0f), (color, value) -> {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], hsb[1], (float)value.intValue() / 100.0f);
    }, string -> {
        float val = Float.parseFloat(string);
        return Math.round(Math.max(0.0f, Math.min(100.0f, val)));
    });

    private final Function<Color, String> getter;
    private final BiFunction<Color, Integer, Color> updater;
    private final Function<String, Integer> parser;

    private ColorType(Function<Color, String> getter, BiFunction<Color, Integer, Color> updater, Function<String, Integer> parser) {
        this.getter = getter;
        this.updater = updater;
        this.parser = parser;
    }

    public String get(Color color) {
        return this.getter.apply(color);
    }

    public Color parseAndUpdate(Color color, String input) {
        try {
            int parsedValue = this.parse(input);
            return this.update(color, parsedValue);
        }
        catch (NumberFormatException e) {
            return color;
        }
    }

    public Color update(Color color, int value) {
        return this.updater.apply(color, value);
    }

    public int parse(String input) throws NumberFormatException {
        return this.parser.apply(input);
    }
}

