/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.common.packet;

import me.andreasmelone.glowingeyes.common.component.data.PlayerDataComponent;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.packet.ComponentUpdatePacket;
import me.andreasmelone.glowingeyes.common.packet.HasModPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerPacketHandler {
    public static void handleHasModPacket(HasModPacket packet, ServerPlayer sender) {
        PlayerDataComponent.setHasMod((Player)sender, true);
        PlayerDataComponent.sendUpdate(sender);
        GlowingEyesComponent.sendUpdate(sender);
        for (Player trackedByPlayer : PlayerDataComponent.getTrackedBy((Player)sender)) {
            ServerPlayer trackedBy = (ServerPlayer)trackedByPlayer;
            if (PlayerDataComponent.hasMod((Player)trackedBy)) {
                GlowingEyesComponent.sendUpdate(trackedBy, sender);
            }
            GlowingEyesComponent.sendUpdate(sender, trackedBy);
        }
    }

    public static void handleComponentUpdatePacket(ComponentUpdatePacket packet, ServerPlayer sender) {
        MinecraftServer server = sender.level().getServer();
        if (server == null) {
            return;
        }
        ServerPlayer target = server.getPlayerList().getPlayer(packet.playerUUID());
        if (target == null) {
            return;
        }
        GlowingEyesComponent.setGlowingEyesMap((Player)target, packet.glowingEyesMap());
        GlowingEyesComponent.setToggledOn((Player)target, packet.toggledOn());
        for (Player serverPlayer : PlayerDataComponent.getTrackedBy((Player)sender)) {
            if (serverPlayer == target) {
                return;
            }
            GlowingEyesComponent.sendUpdate(sender, (ServerPlayer)serverPlayer);
        }
    }
}

