/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.common.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.andreasmelone.glowingeyes.common.scheduler.CodeTask;
import me.andreasmelone.glowingeyes.common.scheduler.Scheduler;
import me.andreasmelone.glowingeyes.common.scheduler.Task;

public class CodeScheduler
implements Scheduler {
    Map<Task, Long> tasksToDelay = new ConcurrentHashMap<Task, Long>();
    Map<Task, DoubleLong> tasksToRepeat = new ConcurrentHashMap<Task, DoubleLong>();

    @Override
    public Task runLater(Runnable runnable, long ticks) {
        CodeTask task = new CodeTask(runnable);
        this.tasksToDelay.put(task, ticks);
        return task;
    }

    @Override
    public Task runRepeating(Runnable runnable, long delayTicks, long intervalTicks) {
        CodeTask task = new CodeTask(runnable);
        this.tasksToRepeat.put(task, new DoubleLong(delayTicks, intervalTicks));
        return task;
    }

    @Override
    public void tick() {
        Task task;
        for (Map.Entry<Task, Long> entry : this.tasksToDelay.entrySet()) {
            task = entry.getKey();
            Long ticks = entry.getValue();
            if (ticks <= 0L) {
                task.run();
                this.tasksToDelay.remove(task);
                continue;
            }
            this.tasksToDelay.replace(task, ticks - 1L);
        }
        for (Map.Entry<Task, Object> entry : this.tasksToRepeat.entrySet()) {
            task = entry.getKey();
            DoubleLong doubleLong = (DoubleLong)entry.getValue();
            long delayTicks = doubleLong.delay;
            long intervalTicks = doubleLong.interval;
            if (delayTicks <= 0L) {
                task.run();
                this.tasksToRepeat.replace(task, new DoubleLong(intervalTicks, intervalTicks));
                continue;
            }
            this.tasksToRepeat.replace(task, new DoubleLong(delayTicks - 1L, intervalTicks));
        }
    }

    private record DoubleLong(long delay, long interval) {
    }
}

