/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Util {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();

    public static <K, V> CompoundTag toCompoundTag(Codec<K> codecK, Codec<V> codecV, Map<K, V> map) {
        CompoundTag tag = new CompoundTag();
        map.forEach((key, value) -> {
            JsonElement encodedKey = (JsonElement)codecK.encodeStart((DynamicOps)JsonOps.INSTANCE, key).result().orElseThrow();
            Tag encodedValue = (Tag)codecV.encodeStart((DynamicOps)NbtOps.INSTANCE, value).result().orElseThrow();
            tag.put(GSON.toJson(encodedKey), encodedValue);
        });
        return tag;
    }

    public static <K, V> Map<K, V> toMap(Codec<K> codecK, Codec<V> codecV, CompoundTag tag) {
        LinkedHashMap map = new LinkedHashMap();
        tag.keySet().forEach(key -> {
            Object decodedKey = codecK.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)key)).map(Pair::getFirst).result().orElseThrow();
            Object decodedValue = codecV.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).map(Pair::getFirst).result().orElseThrow();
            map.put(decodedKey, decodedValue);
        });
        return map;
    }

    public static float round(float value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (float)factor);
        return (float)tmp / (float)factor;
    }

    public static float round(float value) {
        return Util.round(value, 2);
    }

    public static String sanitizeForId(String name) {
        return name.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_]", "_");
    }

    public static ResourceLocation id(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static <T, U> StreamCodec<T, U> emptyStreamCodec(final Supplier<U> constructor) {
        return new StreamCodec<T, U>(){

            @NotNull
            public U decode(@NotNull T t) {
                return constructor.get();
            }

            public void encode(@NotNull T o, @NotNull U u) {
            }
        };
    }

    public static <U> StreamCodec<ByteBuf, U> createStreamCodec(final Function<FriendlyByteBuf, U> decoder, final BiConsumer<FriendlyByteBuf, U> encoder) {
        return new StreamCodec<ByteBuf, U>(){

            public void encode(@NotNull ByteBuf buffer, @NotNull U object) {
                FriendlyByteBuf wrapper = new FriendlyByteBuf(buffer);
                encoder.accept(wrapper, object);
            }

            @NotNull
            public U decode(@NotNull ByteBuf buffer) {
                FriendlyByteBuf wrapper = new FriendlyByteBuf(buffer);
                return decoder.apply(wrapper);
            }
        };
    }

    public static byte[] toByteArray(ByteBuf buf) {
        int length = buf.readableBytes();
        byte[] bytes = new byte[length];
        buf.getBytes(buf.readerIndex(), bytes);
        return bytes;
    }

    public static boolean writeToFile(File file, CompoundTag tag) {
        boolean bl;
        FileOutputStream out = new FileOutputStream(file);
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)out);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to write data to file!", (Throwable)e);
                return false;
            }
        }
        ((OutputStream)out).close();
        return bl;
    }

    public static CompoundTag readFromFile(File file) {
        CompoundTag compoundTag;
        FileInputStream in = new FileInputStream(file);
        try {
            compoundTag = NbtIo.readCompressed((InputStream)in, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to write data to file!", (Throwable)e);
                return null;
            }
        }
        ((InputStream)in).close();
        return compoundTag;
    }
}

