/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.neoforge.client;

import java.io.File;
import me.andreasmelone.glowingeyes.GlowingEyes;
import me.andreasmelone.glowingeyes.client.component.data.ClientPlayerDataComponent;
import me.andreasmelone.glowingeyes.client.component.eyes.ClientGlowingEyesComponent;
import me.andreasmelone.glowingeyes.client.gui.EyesEditorScreen;
import me.andreasmelone.glowingeyes.client.mod.ClientModContext;
import me.andreasmelone.glowingeyes.client.util.DynamicTextureCache;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import me.andreasmelone.glowingeyes.common.util.Util;
import me.andreasmelone.glowingeyes.neoforge.client.GlowingEyesKeybindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class GlowingEyesClientEvents {
    private final ClientModContext mod;
    private final File saveFile = new File("glowingeyes-local.dat");

    public GlowingEyesClientEvents(ClientModContext mod) {
        this.mod = mod;
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        GlowingEyes.SCHEDULER_CLIENT.tick();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        while (GlowingEyesKeybindings.TOGGLE_MAPPING.consumeClick()) {
            GlowingEyesComponent.setToggledOn((Player)player, !GlowingEyesComponent.isToggledOn((Player)player));
            ClientGlowingEyesComponent.sendUpdate();
        }
        while (GlowingEyesKeybindings.EYES_EDITOR_MAPPING.consumeClick()) {
            if (Minecraft.getInstance().screen != null) {
                return;
            }
            Minecraft.getInstance().setScreen((Screen)new EyesEditorScreen(this.mod));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        if (Minecraft.getInstance().player == player) {
            ClientPlayerDataComponent.sendRequest();
            if (this.saveFile.isFile() && this.saveFile.exists()) {
                CompoundTag deserialized = Util.readFromFile(this.saveFile);
                if (deserialized != null) {
                    GlowingEyesComponent.load((Player)player, (HolderLookup.Provider)player.registryAccess(), deserialized);
                } else {
                    Util.LOGGER.error("Failed to read file {}!", (Object)this.saveFile.getName());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        LocalPlayer player = event.getPlayer();
        if (player != null && Minecraft.getInstance().player == player) {
            DynamicTextureCache.clear();
            if (!ClientPlayerDataComponent.isModOnServer()) {
                CompoundTag serialized = GlowingEyesComponent.serialize((Player)player, (HolderLookup.Provider)player.registryAccess());
                if (!Util.writeToFile(this.saveFile, serialized)) {
                    Util.LOGGER.error("Failed to write file {}!", (Object)this.saveFile.getName());
                } else {
                    Util.LOGGER.info("Saved glowing eyes data to {}!", (Object)this.saveFile.getName());
                }
            }
            ClientPlayerDataComponent.setIsModOnServer(false);
        }
    }
}

