/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.neoforge.common;

import me.andreasmelone.glowingeyes.GlowingEyes;
import me.andreasmelone.glowingeyes.common.component.data.PlayerDataComponent;
import me.andreasmelone.glowingeyes.common.component.eyes.GlowingEyesComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class GlowingEyesEvents {
    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer trackedPlayer = (ServerPlayer)entity;
        ServerPlayer playerTracking = (ServerPlayer)event.getEntity();
        PlayerDataComponent.addTrackedBy((Player)playerTracking, (Player)trackedPlayer);
        if (!PlayerDataComponent.hasMod((Player)playerTracking)) {
            return;
        }
        GlowingEyes.SCHEDULER_SERVER.runLater(() -> GlowingEyesComponent.sendUpdate(trackedPlayer, playerTracking), 1L);
    }

    @SubscribeEvent
    public void onPlayerStopTracking(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player target = (Player)entity;
        if (!PlayerDataComponent.hasMod(event.getEntity())) {
            return;
        }
        if (!PlayerDataComponent.hasMod(target)) {
            return;
        }
        PlayerDataComponent.removeTrackedBy(event.getEntity(), target);
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        GlowingEyes.SCHEDULER_SERVER.tick();
    }
}

