/*
 * Decompiled with CFR 0.152.
 */
package me.andreasmelone.glowingeyes.neoforge.common.packets;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.andreasmelone.glowingeyes.client.packet.ClientPacketHandler;
import me.andreasmelone.glowingeyes.common.packet.ComponentUpdatePacket;
import me.andreasmelone.glowingeyes.common.packet.HasModPacket;
import me.andreasmelone.glowingeyes.common.packet.ServerPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("glowingeyes").versioned("4").optional();
        PacketHandler.registerBidirectional(registrar, HasModPacket.TYPE, HasModPacket.STREAM_CODEC, ServerPacketHandler::handleHasModPacket, ClientPacketHandler::handleHasModPacket);
        PacketHandler.registerBidirectional(registrar, ComponentUpdatePacket.TYPE, ComponentUpdatePacket.STREAM_CODEC, ServerPacketHandler::handleComponentUpdatePacket, ClientPacketHandler::handleComponentUpdatePacket);
    }

    public static void sendTo(ServerPlayer target, CustomPacketPayload packet) {
        target.connection.send(packet);
    }

    public static void send(CustomPacketPayload packet) {
        Minecraft.getInstance().getConnection().send(packet);
    }

    private static <T extends CustomPacketPayload> void registerBidirectional(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> reader, BiConsumer<T, ServerPlayer> serverHandler, Consumer<T> clientHandler) {
        registrar.playBidirectional(type, reader, (packet, ctx) -> {
            if (ctx.flow().isServerbound()) {
                serverHandler.accept(packet, (ServerPlayer)ctx.player());
            } else {
                clientHandler.accept(packet);
            }
        });
    }
}

