/*
 * Decompiled with CFR 0.152.
 */
package net.mcbrawls.blueprint.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import net.mcbrawls.blueprint.editor.BlueprintEditorHandler;
import net.mcbrawls.blueprint.editor.BlueprintEditorWorld;
import net.mcbrawls.blueprint.region.CuboidRegion;
import net.mcbrawls.blueprint.region.SphericalRegion;
import net.mcbrawls.blueprint.resource.BlueprintManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u001d\u0010\u0012\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001bR\u0014\u0010 \u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u0014\u0010!\u001a\u00020\u00198\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\u001bR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u0006&"}, d2={"Lnet/mcbrawls/blueprint/command/BlueprintEditorCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "executeOpen", "(Lcom/mojang/brigadier/context/CommandContext;)I", "executeCuboidRegion", "executeSphericalRegion", "executeClose", "executeSave", "Lnet/minecraft/class_243;", "a", "b", "minVec", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "maxVec", "", "BLUEPRINT_KEY", "Ljava/lang/String;", "BLUEPRINT_ID_KEY", "NAME_KEY", "POS_KEY", "FIRST_KEY", "SECOND_KEY", "RADIUS_KEY", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BLUEPRINT_EDITOR_WORLD_EXCEPTION", "blueprint"})
public final class BlueprintEditorCommand {
    @NotNull
    public static final BlueprintEditorCommand INSTANCE = new BlueprintEditorCommand();
    @NotNull
    public static final String BLUEPRINT_KEY = "blueprint";
    @NotNull
    public static final String BLUEPRINT_ID_KEY = "blueprint_id";
    @NotNull
    public static final String NAME_KEY = "name";
    @NotNull
    public static final String POS_KEY = "pos";
    @NotNull
    public static final String FIRST_KEY = "first";
    @NotNull
    public static final String SECOND_KEY = "second";
    @NotNull
    public static final String RADIUS_KEY = "radius";
    @NotNull
    private static final SimpleCommandExceptionType NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You are not in a Blueprint editor."));
    @NotNull
    private static final SimpleCommandExceptionType IN_BLUEPRINT_EDITOR_WORLD_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You are already in a Blueprint editor. Use /blueprint-editor close to leave."));

    private BlueprintEditorCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blueprint-editor").requires(BlueprintEditorCommand::register$lambda$0)).then(class_2170.method_9247((String)"open").then(class_2170.method_9244((String)BLUEPRINT_KEY, (ArgumentType)((ArgumentType)class_2232.method_9441())).suggests(BlueprintEditorCommand::register$lambda$1).executes(this::executeOpen)))).then(class_2170.method_9247((String)"close").executes(this::executeClose))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").executes(this::executeSave)).then(class_2170.method_9244((String)BLUEPRINT_ID_KEY, (ArgumentType)((ArgumentType)class_2232.method_9441())).suggests(BlueprintEditorCommand::register$lambda$2).executes(this::executeSave)))).then(class_2170.method_9247((String)"region").then(((RequiredArgumentBuilder)class_2170.method_9244((String)NAME_KEY, (ArgumentType)((ArgumentType)StringArgumentType.word())).then(class_2170.method_9247((String)"cuboid").then(class_2170.method_9244((String)FIRST_KEY, (ArgumentType)((ArgumentType)class_2277.method_9737())).then(class_2170.method_9244((String)SECOND_KEY, (ArgumentType)((ArgumentType)class_2277.method_9737())).executes(this::executeCuboidRegion))))).then(class_2170.method_9247((String)"sphere").then(class_2170.method_9244((String)POS_KEY, (ArgumentType)((ArgumentType)class_2277.method_9737())).then(class_2170.method_9244((String)RADIUS_KEY, (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)0.0))).executes(this::executeSphericalRegion)))))));
    }

    private final int executeOpen(CommandContext<class_2168> context) {
        class_2960 blueprintId = class_2232.method_9443(context, (String)BLUEPRINT_KEY);
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_9225() instanceof BlueprintEditorWorld) {
            throw IN_BLUEPRINT_EDITOR_WORLD_EXCEPTION.create();
        }
        Intrinsics.checkNotNull((Object)server);
        Intrinsics.checkNotNull((Object)blueprintId);
        if (BlueprintEditorHandler.INSTANCE.open$blueprint(server, blueprintId, source.method_44023())) {
            source.method_9226(() -> BlueprintEditorCommand.executeOpen$lambda$3(blueprintId), true);
        } else {
            source.method_9226(() -> BlueprintEditorCommand.executeOpen$lambda$4(blueprintId), true);
        }
        return 1;
    }

    private final int executeCuboidRegion(CommandContext<class_2168> context) {
        String regionId = StringArgumentType.getString(context, (String)NAME_KEY);
        class_243 firstPos = class_2277.method_9736(context, (String)FIRST_KEY);
        class_243 secondPos = class_2277.method_9736(context, (String)SECOND_KEY);
        Intrinsics.checkNotNull((Object)firstPos);
        Intrinsics.checkNotNull((Object)secondPos);
        class_243 min = this.minVec(firstPos, secondPos);
        class_243 max = this.maxVec(firstPos, secondPos);
        class_243 size = max.method_1020(min);
        class_243 rootPos = min.method_1020(class_243.method_24954((class_2382)((class_2382)BlueprintEditorWorld.Companion.getBLUEPRINT_PLACEMENT_POS())));
        Intrinsics.checkNotNull((Object)rootPos);
        Intrinsics.checkNotNull((Object)size);
        CuboidRegion region = new CuboidRegion(rootPos, size);
        class_2168 source = (class_2168)context.getSource();
        class_3218 class_32182 = source.method_9225();
        BlueprintEditorWorld blueprintEditorWorld = class_32182 instanceof BlueprintEditorWorld ? (BlueprintEditorWorld)class_32182 : null;
        if (blueprintEditorWorld == null) {
            throw NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION.create();
        }
        BlueprintEditorWorld world = blueprintEditorWorld;
        Intrinsics.checkNotNull((Object)regionId);
        world.addRegion(regionId, region);
        source.method_9226(() -> BlueprintEditorCommand.executeCuboidRegion$lambda$5(regionId, rootPos, size), true);
        return 1;
    }

    private final int executeSphericalRegion(CommandContext<class_2168> context) {
        String regionId = StringArgumentType.getString(context, (String)NAME_KEY);
        class_243 pos = class_2277.method_9736(context, (String)POS_KEY);
        double radius = DoubleArgumentType.getDouble(context, (String)RADIUS_KEY);
        class_243 rootPos = pos.method_1020(class_243.method_24954((class_2382)((class_2382)BlueprintEditorWorld.Companion.getBLUEPRINT_PLACEMENT_POS())));
        Intrinsics.checkNotNull((Object)rootPos);
        SphericalRegion region = new SphericalRegion(rootPos, radius);
        class_2168 source = (class_2168)context.getSource();
        class_3218 class_32182 = source.method_9225();
        BlueprintEditorWorld blueprintEditorWorld = class_32182 instanceof BlueprintEditorWorld ? (BlueprintEditorWorld)class_32182 : null;
        if (blueprintEditorWorld == null) {
            throw NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION.create();
        }
        BlueprintEditorWorld world = blueprintEditorWorld;
        Intrinsics.checkNotNull((Object)regionId);
        world.addRegion(regionId, region);
        source.method_9226(() -> BlueprintEditorCommand.executeSphericalRegion$lambda$6(regionId, rootPos, radius), true);
        return 1;
    }

    private final int executeClose(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 class_32182 = source.method_9225();
        BlueprintEditorWorld blueprintEditorWorld = class_32182 instanceof BlueprintEditorWorld ? (BlueprintEditorWorld)class_32182 : null;
        if (blueprintEditorWorld == null) {
            throw NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION.create();
        }
        BlueprintEditorWorld world = blueprintEditorWorld;
        BlueprintEditorHandler.INSTANCE.close$blueprint(world);
        return 1;
    }

    private final int executeSave(CommandContext<class_2168> context) {
        Object $this$executeSave_u24lambda_u247;
        Object object = this;
        try {
            $this$executeSave_u24lambda_u247 = object;
            boolean bl = false;
            $this$executeSave_u24lambda_u247 = Result.constructor-impl((Object)class_2232.method_9443(context, (String)BLUEPRINT_ID_KEY));
        }
        catch (Throwable bl) {
            $this$executeSave_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executeSave_u24lambda_u247;
        class_2960 customBlueprintId = (class_2960)(Result.isFailure-impl((Object)object) ? null : object);
        class_2168 source = (class_2168)context.getSource();
        class_3218 class_32182 = source.method_9225();
        BlueprintEditorWorld blueprintEditorWorld = class_32182 instanceof BlueprintEditorWorld ? (BlueprintEditorWorld)class_32182 : null;
        if (blueprintEditorWorld == null) {
            throw NOT_BLUEPRINT_EDITOR_WORLD_EXCEPTION.create();
        }
        BlueprintEditorWorld world = blueprintEditorWorld;
        if (customBlueprintId != null) {
            String pathString = world.saveBlueprint(customBlueprintId);
            source.method_9226(() -> BlueprintEditorCommand.executeSave$lambda$8(pathString), true);
        } else {
            String pathString = BlueprintEditorWorld.saveBlueprint$default(world, null, 1, null);
            source.method_9226(() -> BlueprintEditorCommand.executeSave$lambda$9(pathString), true);
        }
        return 1;
    }

    @NotNull
    public final class_243 minVec(@NotNull class_243 a, @NotNull class_243 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new class_243(Math.min(a.method_10216(), b.method_10216()), Math.min(a.method_10214(), b.method_10214()), Math.min(a.method_10215(), b.method_10215()));
    }

    @NotNull
    public final class_243 maxVec(@NotNull class_243 a, @NotNull class_243 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new class_243(Math.max(a.method_10216(), b.method_10216()), Math.max(a.method_10214(), b.method_10214()), Math.max(a.method_10215(), b.method_10215()));
    }

    private static final boolean register$lambda$0(class_2168 it) {
        return it.method_9259(2);
    }

    private static final CompletableFuture register$lambda$1(CommandContext commandContext, SuggestionsBuilder suggestions) {
        Intrinsics.checkNotNull((Object)suggestions);
        return BlueprintManager.INSTANCE.suggestBlueprints(suggestions);
    }

    private static final CompletableFuture register$lambda$2(CommandContext commandContext, SuggestionsBuilder suggestions) {
        Intrinsics.checkNotNull((Object)suggestions);
        return BlueprintManager.INSTANCE.suggestBlueprints(suggestions);
    }

    private static final class_2561 executeOpen$lambda$3(class_2960 $blueprintId) {
        return (class_2561)class_2561.method_43470((String)("Opened Blueprint editor for new blueprint \"" + $blueprintId + "\""));
    }

    private static final class_2561 executeOpen$lambda$4(class_2960 $blueprintId) {
        return (class_2561)class_2561.method_43470((String)("Opened Blueprint editor for \"" + $blueprintId + "\""));
    }

    private static final class_2561 executeCuboidRegion$lambda$5(String $regionId, class_243 $rootPos, class_243 $size) {
        return (class_2561)class_2561.method_43470((String)("Marked region \"" + $regionId + "\" at relative " + $rootPos + " (size " + $size + ")"));
    }

    private static final class_2561 executeSphericalRegion$lambda$6(String $regionId, class_243 $rootPos, double $radius) {
        return (class_2561)class_2561.method_43470((String)("Marked region \"" + $regionId + "\" at relative " + $rootPos + " (radius " + $radius + ")"));
    }

    private static final class_2561 executeSave$lambda$8(String $pathString) {
        return (class_2561)class_2561.method_43470((String)("Saved editor blueprint as: \"" + $pathString + "\""));
    }

    private static final class_2561 executeSave$lambda$9(String $pathString) {
        return (class_2561)class_2561.method_43470((String)("Saved editor blueprint: \"" + $pathString + "\""));
    }
}

